/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import org.springframework.beans.BeanWrapperImpl;
import org.springframework.richclient.list.TextValueListRenderer;
import org.springframework.util.Assert;

public class BeanPropertyValueListRenderer
extends TextValueListRenderer {
    private BeanWrapperImpl beanWrapper;
    private String propertyName;

    public BeanPropertyValueListRenderer(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"propertyName can not be null.");
        this.propertyName = propertyName;
    }

    protected String getTextValue(Object value) {
        if (value == null) {
            return "";
        }
        if (this.beanWrapper == null) {
            this.beanWrapper = new BeanWrapperImpl(value);
        } else {
            this.beanWrapper.setWrappedInstance(value);
        }
        return String.valueOf(this.beanWrapper.getPropertyValue(this.propertyName));
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

