/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.form.builder.support.AbstractFormComponentInterceptor;
import org.springframework.richclient.list.ComboBoxAutoCompletion;
import org.springframework.richclient.list.EditableComboBoxAutoCompletion;

public class ComboBoxAutoCompletionInterceptorFactory
implements FormComponentInterceptorFactory {
    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new ComboBoxAutoCompletionInterceptor(formModel);
    }

    public class ComboBoxAutoCompletionInterceptor
    extends AbstractFormComponentInterceptor {
        public ComboBoxAutoCompletionInterceptor(FormModel formModel) {
            super(formModel);
        }

        public void processComponent(String propertyName, JComponent component) {
            JComponent inner = this.getInnerComponent(component);
            if (inner instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)inner;
                if (comboBox.isEditable()) {
                    new EditableComboBoxAutoCompletion(comboBox);
                } else {
                    new ComboBoxAutoCompletion(comboBox);
                }
            }
        }
    }
}

