/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class EditableComboBoxAutoCompletion
extends KeyAdapter {
    private final FocusHandler focusHandler = new FocusHandler();
    private final JComboBox comboBox;
    private final JTextField editor;

    public EditableComboBoxAutoCompletion(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.editor = (JTextField)comboBox.getEditor().getEditorComponent();
        this.editor.addKeyListener(this);
        this.editor.addFocusListener(this.focusHandler);
    }

    public void keyReleased(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch == '\uffff' || Character.isISOControl(ch)) {
            return;
        }
        int pos = this.editor.getCaretPosition();
        String str = this.editor.getText();
        if (str.length() == 0) {
            return;
        }
        boolean matchFound = false;
        for (int k = 0; k < this.comboBox.getItemCount(); ++k) {
            String item = this.comboBox.getItemAt(k).toString();
            if (!this.startsWithIgnoreCase(item, str)) continue;
            this.comboBox.setSelectedIndex(k);
            this.editor.setText(item);
            this.editor.setCaretPosition(item.length());
            this.editor.moveCaretPosition(pos);
            if (this.comboBox.isDisplayable()) {
                this.comboBox.setPopupVisible(true);
            }
            matchFound = true;
            break;
        }
        if (!matchFound) {
            this.comboBox.setPopupVisible(false);
        }
    }

    private boolean startsWithIgnoreCase(String str1, String str2) {
        return str1 != null && str2 != null && str1.toUpperCase().startsWith(str2.toUpperCase());
    }

    private void highlightText(int start) {
        this.editor.setCaretPosition(this.editor.getText().length());
        this.editor.moveCaretPosition(start);
    }

    private final class FocusHandler
    implements FocusListener {
        private boolean hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");

        private FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            EditableComboBoxAutoCompletion.this.highlightText(0);
        }

        public void focusLost(FocusEvent e) {
            if (this.hidePopupOnFocusLoss) {
                EditableComboBoxAutoCompletion.this.comboBox.setPopupVisible(false);
            }
        }
    }
}

