/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.util.Observable;
import java.util.Observer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import org.springframework.richclient.list.AbstractFilteredListModel;
import org.springframework.rules.constraint.Constraint;
import org.springframework.util.Assert;

public class FilteredListModel
extends AbstractFilteredListModel
implements Observer {
    private Constraint constraint;
    private int[] indexes;
    private int filteredSize;

    public FilteredListModel(ListModel listModel, Constraint constraint) {
        super(listModel);
        this.setConstraint(constraint);
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        this.reallocateIndexes();
        super.fireContentsChanged(source, index0, index1);
    }

    public final void setConstraint(Constraint constraint) {
        Assert.notNull((Object)constraint);
        if (!constraint.equals(this.constraint)) {
            if (this.constraint instanceof Observable) {
                ((Observable)((Object)constraint)).deleteObserver(this);
            }
            this.constraint = constraint;
            if (constraint instanceof Observable) {
                ((Observable)((Object)constraint)).addObserver(this);
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    protected void reallocateIndexes() {
        if (this.indexes == null || this.indexes.length != this.getFilteredModel().getSize()) {
            this.indexes = new int[this.getFilteredModel().getSize()];
        }
        this.applyConstraint();
    }

    public void update(Observable changed, Object arg) {
        this.fireContentsChanged(this, -1, -1);
    }

    private void applyConstraint() {
        this.filteredSize = 0;
        ListModel filteredListModel = this.getFilteredModel();
        int size = filteredListModel.getSize();
        for (int i = 0; i < size; ++i) {
            Object element = filteredListModel.getElementAt(i);
            if (!this.constraint.test(element)) continue;
            this.indexes[this.filteredSize++] = i;
            this.onMatchingElement(element);
        }
        this.postConstraintApplied();
    }

    protected void onMatchingElement(Object element) {
    }

    protected void postConstraintApplied() {
    }

    public int getSize() {
        return this.filteredSize;
    }

    public int getElementIndex(int filteredIndex) {
        return this.indexes[filteredIndex];
    }

    public void contentsChanged(ListDataEvent e) {
        this.reallocateIndexes();
        super.contentsChanged(e);
    }

    public void intervalAdded(ListDataEvent e) {
        this.reallocateIndexes();
        super.intervalAdded(e);
    }

    public void intervalRemoved(ListDataEvent e) {
        this.reallocateIndexes();
        super.intervalRemoved(e);
    }
}

