/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.util.List;
import javax.swing.ListModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.list.AbstractFilteredListModel;
import org.springframework.richclient.list.SingleListSelectionGuard;

public class ListUtils {
    private ListUtils() {
    }

    public static ActionCommand createRemoveRowCommand(final List list, final ValueModel selectionIndexHolder) {
        ActionCommand removeCommand = new ActionCommand("removeCommand"){

            protected void doExecuteCommand() {
                int selectedRowIndex = (Integer)selectionIndexHolder.getValue();
                list.remove(selectedRowIndex);
            }
        };
        new SingleListSelectionGuard(selectionIndexHolder, removeCommand);
        return removeCommand;
    }

    public static ListModel getFilteredListModel(ListModel listModel) {
        if (listModel instanceof AbstractFilteredListModel) {
            return ListUtils.getFilteredListModel(((AbstractFilteredListModel)listModel).getFilteredModel());
        }
        return listModel;
    }

    public static int getElementIndex(ListModel listModel, int filteredIndex) {
        if (listModel instanceof AbstractFilteredListModel) {
            AbstractFilteredListModel filteredModel = (AbstractFilteredListModel)listModel;
            return ListUtils.getElementIndex(filteredModel.getFilteredModel(), filteredModel.getElementIndex(filteredIndex));
        }
        return filteredIndex;
    }
}

