/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.progress;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class BusyIndicator {
    public static void showWhile(Component component, Runnable runnable) {
        if (component != null) {
            BusyIndicator.showAt(component);
        }
        try {
            runnable.run();
        }
        catch (RuntimeException x) {
            x.printStackTrace();
            throw x;
        }
        catch (Error x) {
            x.printStackTrace();
            throw x;
        }
        finally {
            if (component != null) {
                BusyIndicator.clearAt(component);
            }
        }
    }

    public static void showAt(Component component) {
        JRootPane root = SwingUtilities.getRootPane(component);
        if (root != null && root.isShowing()) {
            root.setGlassPane(BusyGlassPanel.INSTANCE);
            root.getGlassPane().setVisible(true);
        }
    }

    public static void clearAt(Component component) {
        JRootPane root = SwingUtilities.getRootPane(component);
        if (root != null && root.isShowing()) {
            root.getGlassPane().setVisible(false);
        }
    }

    public static class BusyGlassPanel
    extends JPanel {
        public static final Component INSTANCE = new BusyGlassPanel();

        public static Component instance() {
            return INSTANCE;
        }

        public BusyGlassPanel() {
            super.setOpaque(false);
            super.setCursor(Cursor.getPredefinedCursor(3));
            super.addKeyListener(new KeyAdapter(){});
            super.addMouseListener(new MouseAdapter(){});
            super.addMouseMotionListener(new MouseMotionAdapter(){});
        }
    }
}

