/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security;

import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.security.ApplicationSecurityManager;
import org.springframework.rules.PropertyConstraintProvider;
import org.springframework.rules.Rules;
import org.springframework.rules.constraint.Constraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.security.Authentication;

public class LoginDetails
implements PropertyConstraintProvider {
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_PASSWORD = "password";
    private String username;
    private String password;
    private Rules validationRules;

    public LoginDetails() {
        ApplicationSecurityManager sm = (ApplicationSecurityManager)ApplicationServicesLocator.services().getService(ApplicationSecurityManager.class);
        Authentication authentication = sm.getAuthentication();
        if (authentication != null) {
            this.setUsername(authentication.getName());
        }
        this.initRules();
    }

    protected void initRules() {
        this.validationRules = new Rules(this.getClass()){

            protected void initRules() {
                this.add(LoginDetails.PROPERTY_USERNAME, this.all(new Constraint[]{this.required(), this.minLength(this.getUsernameMinLength())}));
                this.add(LoginDetails.PROPERTY_PASSWORD, this.all(new Constraint[]{this.required(), this.minLength(this.getPasswordMinLength())}));
            }

            protected int getUsernameMinLength() {
                return 2;
            }

            protected int getPasswordMinLength() {
                return 2;
            }
        };
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PropertyConstraint getPropertyConstraint(String propertyName) {
        return this.validationRules.getPropertyConstraint(propertyName);
    }
}

