/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.selection.binding;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.beans.BeanTextFilterator;
import ca.odell.glazedlists.impl.filter.StringTextFilterator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.form.binding.support.CustomBinding;
import org.springframework.richclient.selection.binding.support.LabelProvider;
import org.springframework.richclient.selection.binding.support.LabelProviderListCellRenderer;
import org.springframework.richclient.selection.binding.support.SelectField;
import org.springframework.richclient.selection.binding.support.ValueModel2EventListBridge;
import org.springframework.richclient.selection.dialog.FilterListSelectionDialog;
import org.springframework.richclient.selection.dialog.ListSelectionDialog;
import org.springframework.rules.closure.Closure;
import org.springframework.rules.closure.support.Block;
import org.springframework.util.StringUtils;

public class ListSelectionDialogBinding
extends CustomBinding {
    protected SelectField selectField;
    private boolean filtered;
    private String[] filterProperties;
    private ListCellRenderer renderer;
    private ValueModel selectableItemsHolder;
    private LabelProvider labelProvider;
    private Comparator comparator;
    private String descriptionKey;
    private String titleKey;
    private boolean nullable = true;

    protected ListSelectionDialogBinding(SelectField selectField, FormModel formModel, String formPropertyPath) {
        super(formModel, formPropertyPath, null);
        this.selectField = selectField;
    }

    protected JComponent doBindControl() {
        this.selectField.setLabelProvider(this.labelProvider);
        this.selectField.setSelectionDialog(this.createSelectionDialog());
        this.selectField.setNullable(this.nullable);
        this.selectField.getControl();
        this.selectField.setValue(this.getValue());
        this.selectField.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ListSelectionDialogBinding.this.controlValueChanged(ListSelectionDialogBinding.this.selectField.getValue());
            }
        });
        return this.selectField.getControl();
    }

    protected ApplicationDialog createSelectionDialog() {
        EventList eventList = this.createEventList(this.selectableItemsHolder);
        final ValueModel2EventListBridge itemRefresher = new ValueModel2EventListBridge(this.selectableItemsHolder, eventList, true);
        ListSelectionDialog selectionDialog = null;
        if (this.filtered) {
            FilterListSelectionDialog filterDialog = new FilterListSelectionDialog("", null, new FilterList(eventList));
            if (this.filterProperties == null) {
                filterDialog.setFilterator((TextFilterator)new StringTextFilterator());
            } else {
                filterDialog.setFilterator((TextFilterator)new BeanTextFilterator(this.filterProperties));
            }
            selectionDialog = filterDialog;
        } else {
            selectionDialog = new ListSelectionDialog("", null, eventList);
        }
        selectionDialog.setOnAboutToShow(new Block(){

            protected void handle(Object ignore) {
                itemRefresher.synchronize();
            }
        });
        selectionDialog.setOnSelectAction(new Closure(){

            public Object call(Object argument) {
                ListSelectionDialogBinding.this.controlValueChanged(argument);
                ListSelectionDialogBinding.this.selectField.setValue(argument);
                return argument;
            }
        });
        selectionDialog.setRenderer(this.getRendererForSelectionDialog());
        if (StringUtils.hasText((String)this.descriptionKey)) {
            String description = this.getMessage(this.descriptionKey);
            selectionDialog.setDescription(description);
        }
        if (StringUtils.hasText((String)this.titleKey)) {
            String title = this.getMessage(this.titleKey);
            selectionDialog.setTitle(title);
        }
        return selectionDialog;
    }

    private EventList createEventList(ValueModel selectableItemsHolder) {
        EventList eventList = GlazedLists.eventList(Collections.emptyList());
        if (this.comparator != null) {
            eventList = new SortedList(eventList, this.comparator);
        }
        return eventList;
    }

    protected ListCellRenderer getRendererForSelectionDialog() {
        if (this.renderer != null) {
            return this.renderer;
        }
        if (this.labelProvider != null) {
            return new LabelProviderListCellRenderer(this.labelProvider);
        }
        return null;
    }

    protected void enabledChanged() {
        this.selectField.setEnabled(this.isEnabled());
    }

    protected void readOnlyChanged() {
        this.selectField.setEditable(!this.isReadOnly());
    }

    public void setLabelProvider(LabelProvider provider) {
        this.labelProvider = provider;
    }

    protected void valueModelChanged(Object newValue) {
        this.selectField.setValue(newValue);
    }

    public void setFilterProperties(String[] filterProperties) {
        this.filterProperties = filterProperties;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
    }

    public void setSelectableItemsHolder(ValueModel selectableItemsHolder) {
        this.selectableItemsHolder = selectableItemsHolder;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }
}

