/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.selection.binding.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.binding.value.PropertyChangePublisher;
import org.springframework.binding.value.support.PropertyChangeSupport;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.selection.binding.support.LabelProvider;

public abstract class SelectField
extends AbstractControlFactory
implements PropertyChangePublisher {
    private JComponent renderer;
    private SelectCommand selectCommand = new SelectCommand();
    private ClearCommand clearCommand = new ClearCommand();
    private boolean editable;
    private Object value;
    private ApplicationDialog dialog;
    private LabelProvider labelProvider;
    private JPanel control;
    private boolean nullable = true;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected JComponent createControl() {
        this.control = new JPanel(new BorderLayout());
        this.renderer = this.createRenderer();
        this.control.add(this.renderer);
        CommandConfigurer configurer = (CommandConfigurer)ApplicationServicesLocator.services().getService(CommandConfigurer.class);
        configurer.configure(this.selectCommand);
        configurer.configure(this.clearCommand);
        JPanel buttonPanel = new JPanel(new FlowLayout(3, 0, 0));
        buttonPanel.add(this.selectCommand.createButton());
        if (this.nullable) {
            buttonPanel.add(this.clearCommand.createButton());
        }
        this.control.add((Component)buttonPanel, "After");
        return this.control;
    }

    protected abstract JComponent createRenderer();

    public void setEnabled(boolean enabled) {
        this.control.setEnabled(enabled);
        this.renderer.setEnabled(enabled);
        this.selectCommand.setEnabled(enabled);
        this.clearCommand.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.selectCommand.setEnabled(this.control.isEnabled() && editable);
        this.clearCommand.setEnabled(this.control.isEnabled() && editable);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        this.render(value);
        this.propertyChangeSupport.firePropertyChange("value", oldValue, value);
    }

    public void clear() {
        this.setValue(null);
    }

    protected abstract void render(Object var1);

    public Object getValue() {
        return this.value;
    }

    public void setSelectionDialog(ApplicationDialog dialog) {
        this.dialog = dialog;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private class SelectCommand
    extends ActionCommand {
        public SelectCommand() {
            super("selectField.selectCommand");
        }

        protected void doExecuteCommand() {
            SelectField.this.dialog.showDialog();
        }
    }

    private class ClearCommand
    extends ActionCommand {
        public ClearCommand() {
            super("selectField.clearCommand");
        }

        protected void doExecuteCommand() {
            SelectField.this.clear();
        }
    }
}

