/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.selection.dialog;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.springframework.richclient.selection.dialog.AbstractSelectionDialog;
import org.springframework.util.Assert;

public class ListSelectionDialog
extends AbstractSelectionDialog {
    private ListCellRenderer renderer;
    private JList list;
    private EventList items;

    public ListSelectionDialog(String title, List items) {
        this(title, null, GlazedLists.eventList((Collection)items));
    }

    public ListSelectionDialog(String title, Window parent, List items) {
        this(title, parent, GlazedLists.eventList((Collection)items));
    }

    public ListSelectionDialog(String title, Window parent, EventList items) {
        super(title, parent);
        this.items = items;
    }

    public void setRenderer(ListCellRenderer renderer) {
        Assert.notNull((Object)renderer, (String)"Renderer cannot be null.");
        Assert.isTrue((!this.isControlCreated() ? 1 : 0) != 0, (String)"Install the renderer before the control is created.");
        this.renderer = renderer;
    }

    protected JComponent createSelectionComponent() {
        this.list = this.getComponentFactory().createList();
        this.list.setModel(new EventListModel(this.items));
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){
            private int lastIndex = -1;

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (ListSelectionDialog.this.list.getSelectionModel().isSelectionEmpty() && this.lastIndex > -1 && ListSelectionDialog.this.list.getModel().getSize() > 0) {
                    ListSelectionDialog.this.list.setSelectedIndex(this.lastIndex);
                    return;
                }
                ListSelectionDialog.this.setFinishEnabled(!ListSelectionDialog.this.list.getSelectionModel().isSelectionEmpty());
                this.lastIndex = ListSelectionDialog.this.list.getSelectedIndex();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListSelectionDialog.this.getFinishCommand().execute();
                }
            }
        });
        if (this.renderer != null) {
            this.list.setCellRenderer(this.renderer);
        }
        this.setFinishEnabled(false);
        if (!this.items.isEmpty()) {
            this.list.setSelectedIndex(0);
        }
        return new JScrollPane(this.list);
    }

    protected Object getSelectedObject() {
        return this.items.get(this.list.getSelectedIndex());
    }

    protected final JList getList() {
        return this.list;
    }
}

