/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.springframework.richclient.table.ColumnToSort;
import org.springframework.richclient.table.SortOrder;

public class ColumnSortList
extends Observable {
    public static final int MAX_SORT_LEVELS = 4;
    private List sortLevels = new ArrayList();

    public ColumnToSort getSortLevel(int columnIndex) {
        return this.findColumnToSort(columnIndex);
    }

    public ColumnToSort[] getSortLevels() {
        return this.sortLevels.toArray(new ColumnToSort[0]);
    }

    public int size() {
        return this.sortLevels.size();
    }

    public boolean isSorted(int columnIndex) {
        return this.findColumnToSort(columnIndex) != null;
    }

    public void addSortLevel(int columnIndex, SortOrder order) {
        if (this.sortLevels.size() == 4) {
            throw new IllegalArgumentException("Max sort level reached.");
        }
        this.sortLevels.add(new ColumnToSort(this.sortLevels.size(), columnIndex, order));
        this.setChanged();
        this.notifyObservers();
    }

    public void toggleSortOrder(int columnIndex) {
        ColumnToSort column = this.findColumnToSort(columnIndex);
        if (column == null) {
            throw new IllegalArgumentException("No such sorted column.");
        }
        column.toggleSortOrder();
        this.setChanged();
        this.notifyObservers();
    }

    public void setSingleSortLevel(int columnIndex, SortOrder order) {
        this.sortLevels.clear();
        this.addSortLevel(columnIndex, order);
    }

    private ColumnToSort findColumnToSort(int columnIndex) {
        for (ColumnToSort column : this.sortLevels) {
            if (column.getColumnIndex() != columnIndex) continue;
            return column;
        }
        return null;
    }
}

