/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.progress.BusyIndicator;
import org.springframework.richclient.table.ColumnSortList;
import org.springframework.richclient.table.SortableTableModel;
import org.springframework.richclient.table.TableUtils;
import org.springframework.util.Assert;

public class SortTableCommand
extends ActionCommand
implements Observer {
    private JTable table;
    private SortableTableModel sortableTableModel;
    private ColumnSortList sortList;

    public SortTableCommand(JTable table, ColumnSortList sortList) {
        super("sortCommand");
        this.table = table;
        Assert.isTrue((boolean)(table.getModel() instanceof SortableTableModel), (String)"The specified table's model must be sortable!");
        this.sortableTableModel = (SortableTableModel)table.getModel();
        this.sortList = sortList;
        this.sortList.addObserver(this);
    }

    public void update(Observable o, Object args) {
        this.doSort();
    }

    protected void doExecuteCommand() {
        this.doSort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSort() {
        try {
            BusyIndicator.showAt(this.table);
            int[] preSortSelectedRows = this.table.getSelectedRows();
            int[] postSortSelectedRows = this.sortableTableModel.sortByColumns(this.sortList.getSortLevels(), preSortSelectedRows);
            for (int i = 0; i < postSortSelectedRows.length; ++i) {
                this.table.addRowSelectionInterval(postSortSelectedRows[i], postSortSelectedRows[i]);
            }
            if (postSortSelectedRows.length > 0) {
                TableUtils.scrollToRow(this.table, postSortSelectedRows[0]);
            }
        }
        finally {
            BusyIndicator.clearAt(this.table);
        }
    }

    public void dispose() {
        this.sortList.deleteObserver(this);
    }
}

