/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.springframework.richclient.image.ArrowIcon;
import org.springframework.richclient.table.ColumnSortList;
import org.springframework.richclient.table.ColumnToSort;
import org.springframework.richclient.table.SortOrder;
import org.springframework.richclient.table.TableUtils;
import org.springframework.util.Assert;

public class TableSortIndicator
implements TableColumnModelListener {
    public static final ArrowIcon STANDARD_UP_ARROW = new ArrowIcon(ArrowIcon.Direction.UP, 4, SystemColor.controlDkShadow);
    public static final ArrowIcon STANDARD_DOWN_ARROW = new ArrowIcon(ArrowIcon.Direction.DOWN, 4, SystemColor.controlDkShadow);
    private final TableHeaderClickHandler tableHeaderClickHandler = new TableHeaderClickHandler();
    private JTable table;
    private Icon ascendingIcon;
    private Icon descendingIcon;
    private ColumnSortList sortList;

    public TableSortIndicator(JTable table) {
        this(table, STANDARD_UP_ARROW, STANDARD_DOWN_ARROW);
    }

    public TableSortIndicator(JTable table, Icon ascendingIcon, Icon descendingIcon) {
        Assert.notNull((Object)table);
        Assert.notNull((Object)ascendingIcon);
        Assert.notNull((Object)descendingIcon);
        this.table = table;
        this.ascendingIcon = ascendingIcon;
        this.descendingIcon = descendingIcon;
        this.sortList = new ColumnSortList();
        this.initHeaderRenderers();
        this.table.getColumnModel().addColumnModelListener(this);
        this.table.getTableHeader().addMouseListener(this.tableHeaderClickHandler);
    }

    public ColumnSortList getColumnSortList() {
        return this.sortList;
    }

    private void initHeaderRenderers() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn col = this.table.getColumnModel().getColumn(i);
            col.setHeaderRenderer(new HeaderRenderer(this.table.getTableHeader()));
            col.setPreferredWidth(TableUtils.calculatePreferredColumnWidth(this.table, col));
            col.setWidth(col.getPreferredWidth());
        }
    }

    private void displayRendererIcon(int column, SortOrder order) {
        HeaderRenderer rend = this.getRenderer(column);
        if (order == SortOrder.ASCENDING) {
            rend.setIcon(this.ascendingIcon);
        } else {
            rend.setIcon(this.descendingIcon);
        }
    }

    private void removeRendererIcons() {
        TableColumnModel colModel = this.table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            HeaderRenderer rend = (HeaderRenderer)colModel.getColumn(i).getHeaderRenderer();
            rend.setIcon(null);
        }
    }

    private HeaderRenderer getRenderer(int columnIndex) {
        TableColumn column = this.table.getColumnModel().getColumn(columnIndex);
        return (HeaderRenderer)column.getHeaderRenderer();
    }

    public void columnAdded(TableColumnModelEvent e) {
        TableColumn column = this.table.getColumnModel().getColumn(e.getToIndex());
        if (column.getHeaderRenderer() instanceof HeaderRenderer) {
            ((HeaderRenderer)column.getHeaderRenderer()).setIcon(null);
        } else {
            column.setHeaderRenderer(new HeaderRenderer(this.table.getTableHeader()));
        }
    }

    public void columnMarginChanged(ChangeEvent e) {
    }

    public void columnMoved(TableColumnModelEvent e) {
    }

    public void columnRemoved(TableColumnModelEvent e) {
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    private static final class HeaderRenderer
    extends DefaultTableCellRenderer {
        private JTableHeader tableHeader;

        public HeaderRenderer(JTableHeader header) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setIconTextGap(11);
            this.setHorizontalTextPosition(2);
            this.tableHeader = header;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean iSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            this.setFont(this.tableHeader.getFont());
            return this;
        }
    }

    private class TableHeaderClickHandler
    extends MouseAdapter {
        private TableHeaderClickHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isMetaDown()) {
                return;
            }
            int columnView = TableSortIndicator.this.table.getColumnModel().getColumnIndexAtX(e.getX());
            if (columnView == -1) {
                return;
            }
            Rectangle r = TableSortIndicator.this.table.getTableHeader().getHeaderRect(columnView);
            r.grow(-3, 0);
            if (!r.contains(e.getPoint())) {
                return;
            }
            int column = TableSortIndicator.this.table.convertColumnIndexToModel(columnView);
            int shiftPressed = e.getModifiers() & 1;
            ColumnToSort columnToSort = TableSortIndicator.this.sortList.getSortLevel(column);
            if (columnToSort != null) {
                if (shiftPressed == 1) {
                    TableSortIndicator.this.sortList.toggleSortOrder(column);
                    TableSortIndicator.this.displayRendererIcon(column, columnToSort.getSortOrder());
                } else {
                    SortOrder order = TableSortIndicator.this.sortList.size() > 1 ? SortOrder.ASCENDING : columnToSort.getSortOrder().flip();
                    TableSortIndicator.this.sortList.setSingleSortLevel(column, order);
                    TableSortIndicator.this.removeRendererIcons();
                    TableSortIndicator.this.displayRendererIcon(columnView, order);
                }
            } else if (shiftPressed == 1) {
                try {
                    TableSortIndicator.this.sortList.addSortLevel(column, SortOrder.ASCENDING);
                    TableSortIndicator.this.displayRendererIcon(columnView, SortOrder.ASCENDING);
                }
                catch (IllegalArgumentException ex) {
                    JOptionPane.showMessageDialog(TableSortIndicator.this.table.getTopLevelAncestor(), "Maximum number of sort levels reached.", "Table Sorter", 2);
                    return;
                }
            } else {
                TableSortIndicator.this.sortList.setSingleSortLevel(column, SortOrder.ASCENDING);
                TableSortIndicator.this.removeRendererIcons();
                TableSortIndicator.this.displayRendererIcon(columnView, SortOrder.ASCENDING);
            }
            TableSortIndicator.this.table.getTableHeader().resizeAndRepaint();
        }
    }
}

