/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.taskpane;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.taskpane.IconGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskPaneIconGenerator
implements IconGenerator<AbstractCommand> {
    public static final int ROUND = 0;
    public static final int DIAMOND = 1;
    public static final int SQUARE = 2;
    public static final int OCTAGON = 3;
    private Color iconColor = Color.DARK_GRAY;
    private int iconShape = 2;

    public Color getIconColor() {
        return this.iconColor;
    }

    public void setIconColor(Color iconColor) {
        this.iconColor = iconColor;
    }

    public int getIconShape() {
        return this.iconShape;
    }

    public void setIconShape(int iconShape) {
        this.iconShape = iconShape;
    }

    @Override
    public ImageIcon generateIcon(AbstractCommand forObject) {
        char textChar = forObject.getText().charAt(0);
        return new ImageIcon(DefaultTaskPaneIconGenerator.createIcon(this.getIconShape(), this.getIconColor(), textChar));
    }

    private static BufferedImage createIcon(int style, Color color, char text) {
        BufferedImage img = new BufferedImage(16, 16, 2);
        Graphics2D g = img.createGraphics();
        Color lighterColor = color.brighter().brighter();
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, lighterColor, 16.0f, 16.0f, color);
        g.setPaint(paint);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Polygon p = new Polygon();
        switch (style) {
            case 0: {
                g.fillOval(0, 0, 16, 16);
                break;
            }
            case 2: {
                g.fillRect(0, 0, 16, 16);
                break;
            }
            case 1: {
                p.addPoint(8, 0);
                p.addPoint(16, 8);
                p.addPoint(8, 16);
                p.addPoint(0, 8);
                g.fillPolygon(p);
                break;
            }
            case 3: {
                p.addPoint(0, 5);
                p.addPoint(5, 0);
                p.addPoint(11, 0);
                p.addPoint(16, 5);
                p.addPoint(16, 11);
                p.addPoint(11, 16);
                p.addPoint(5, 16);
                p.addPoint(0, 11);
                g.fillPolygon(p);
                break;
            }
        }
        g.setFont(new Font("SansSerif", 0, 10));
        g.setColor(Color.white);
        char uppercaseText = Character.toUpperCase(text);
        if (uppercaseText == 'W' || uppercaseText == 'M') {
            g.drawString(Character.toString(text), 3.0f, 11.0f);
        } else {
            g.drawString(Character.toString(text), 4.5f, 11.0f);
        }
        img.flush();
        return img;
    }
}

