/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.taskpane;

import com.l2fprod.common.swing.JLinkButton;
import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.JTaskPaneGroup;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.CommandGroupJComponentBuilder;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.taskpane.IconGenerator;
import org.springframework.richclient.taskpane.JTaskPaneCommandButtonConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTaskPaneBuilder
extends CommandGroupJComponentBuilder {
    private IconSource iconSource = null;
    private boolean onlyOneExpanded = true;
    private JTaskPaneCommandButtonConfigurer configurer = new JTaskPaneCommandButtonConfigurer();
    private IconGenerator<AbstractCommand> iconGenerator;

    @Override
    protected JComponent buildRootComponent(AbstractCommand command) {
        JTaskPane pane = new JTaskPane();
        pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.setOpaque(false);
        return pane;
    }

    @Override
    protected JComponent buildChildComponent(JComponent parentComponent, AbstractCommand command, int level) {
        if (command != null) {
            JLinkButton button = new JLinkButton();
            command.attach((AbstractButton)button, this.configurer);
            parentComponent.add((Component)button);
            return button;
        }
        return null;
    }

    public boolean hasOnlyOneExpanded() {
        return this.onlyOneExpanded;
    }

    public void setOnlyOneExpanded(boolean onlyOneExpanded) {
        this.onlyOneExpanded = onlyOneExpanded;
    }

    @Override
    protected JComponent buildGroupComponent(JComponent parentComponent, CommandGroup command, int level) {
        if (level == 0) {
            return parentComponent;
        }
        if (this.iconSource == null) {
            this.iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
        }
        Icon icon = command.getIcon() == null && this.iconGenerator != null ? this.iconGenerator.generateIcon(command) : command.getIcon();
        if (parentComponent instanceof JTaskPaneGroup) {
            final JTaskPaneGroup parent = (JTaskPaneGroup)parentComponent;
            final JTaskPaneGroup group = new JTaskPaneGroup();
            group.setTitle(command.getText());
            group.setIcon(icon);
            group.setExpanded(false);
            if (this.hasOnlyOneExpanded()) {
                group.addPropertyChangeListener("expanded", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (((Boolean)evt.getNewValue()).booleanValue()) {
                            Component[] comps = parent.getComponents();
                            for (int i = 0; i < comps.length; ++i) {
                                JTaskPaneGroup g;
                                if (!(comps[i] instanceof JTaskPaneGroup) || comps[i] == group || !(g = (JTaskPaneGroup)comps[i]).isExpanded()) continue;
                                g.setExpanded(false);
                            }
                        }
                    }
                });
            }
            parent.add((Component)group);
            return group;
        }
        final JTaskPane parent = (JTaskPane)parentComponent;
        final JTaskPaneGroup group = new JTaskPaneGroup();
        group.setTitle(command.getText());
        group.setIcon(icon);
        group.setExpanded(false);
        if (this.hasOnlyOneExpanded()) {
            group.addPropertyChangeListener("expanded", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        Component[] comps = parent.getComponents();
                        for (int i = 0; i < comps.length; ++i) {
                            JTaskPaneGroup g;
                            if (!(comps[i] instanceof JTaskPaneGroup) || comps[i] == group || !(g = (JTaskPaneGroup)comps[i]).isExpanded()) continue;
                            g.setExpanded(false);
                        }
                    }
                }
            });
        }
        parent.add(group);
        return group;
    }

    public IconGenerator<AbstractCommand> getIconGenerator() {
        return this.iconGenerator;
    }

    public void setIconGenerator(IconGenerator<AbstractCommand> iconGenerator) {
        this.iconGenerator = iconGenerator;
    }
}

