/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.taskpane;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.config.NavigatorApplicationLifecycleAdvisor;
import org.springframework.richclient.application.support.DefaultApplicationWindow;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.taskpane.IconGenerator;
import org.springframework.richclient.taskpane.TaskPaneNavigatorView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPaneNavigatorApplicationWindow
extends DefaultApplicationWindow {
    private JSplitPane framedPage;
    private boolean onlyOneExpanded;
    private IconGenerator<AbstractCommand> taskPaneIconGenerator;

    @Override
    protected JComponent createWindowContentPane() {
        CommandGroup navigationCommandGroup = ((NavigatorApplicationLifecycleAdvisor)this.getAdvisor()).getNavigationCommandGroup();
        TaskPaneNavigatorView taskPaneNavigatorView = new TaskPaneNavigatorView(navigationCommandGroup);
        taskPaneNavigatorView.setIconGenerator(this.getTaskPaneIconGenerator());
        taskPaneNavigatorView.setOnlyOneExpanded(this.onlyOneExpanded);
        this.framedPage = new JSplitPane(1, true, new JScrollPane(taskPaneNavigatorView.getControl(), 22, 31), null);
        this.framedPage.setOneTouchExpandable(true);
        return this.framedPage;
    }

    public boolean hasOnlyOneExpanded() {
        return this.onlyOneExpanded;
    }

    public void setOnlyOneExpanded(boolean onlyOneExpanded) {
        this.onlyOneExpanded = onlyOneExpanded;
    }

    @Override
    protected void setActivePage(ApplicationPage page) {
        this.framedPage.setRightComponent(page.getControl());
        this.framedPage.revalidate();
    }

    public IconGenerator<AbstractCommand> getTaskPaneIconGenerator() {
        return this.taskPaneIconGenerator;
    }

    public void setTaskPaneIconGenerator(IconGenerator<AbstractCommand> taskPaneIconGenerator) {
        this.taskPaneIconGenerator = taskPaneIconGenerator;
    }
}

