/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.text;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.text.TextComponentInterceptor;

public class SelectAllFormComponentInterceptorFactory
implements FormComponentInterceptorFactory {
    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new SelectAllFormComponentInterceptor();
    }

    public class SelectAllFormComponentInterceptor
    extends TextComponentInterceptor {
        private FocusListener selector = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    final JTextComponent textComponent = (JTextComponent)e.getComponent();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            textComponent.selectAll();
                        }
                    });
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    final JTextComponent textComponent = (JTextComponent)e.getComponent();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            textComponent.select(0, 0);
                        }
                    });
                }
            }
        };

        protected void processComponent(String propertyName, JTextComponent textComponent) {
            textComponent.addFocusListener(this.selector);
        }
    }
}

