/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.text;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.undo.UndoManager;
import org.springframework.binding.value.CommitTrigger;
import org.springframework.binding.value.CommitTriggerListener;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.CommandManager;
import org.springframework.richclient.command.TargetableActionCommand;
import org.springframework.richclient.command.support.AbstractActionCommandExecutor;
import org.springframework.richclient.command.support.DefaultCommandManager;

public class TextComponentPopup
extends MouseAdapter
implements FocusListener,
CaretListener,
UndoableEditListener {
    private static final int PAST_REFRESH_TIMER_DELAY = 100;
    private static final String[] COMMANDS = new String[]{"undoCommand", "redoCommand", "copyCommand", "cutCommand", "pasteCommand", "selectAllCommand"};
    private final JTextComponent textComponent;
    private final Timer updatePasteStatusTimer;
    private final UndoManager undoManager = new UndoManager();
    private final CommitTrigger resetUndoHistoryTrigger;
    private static CommandManager localCommandManager;
    private final UndoCommandExecutor undo = new UndoCommandExecutor();
    private final RedoCommandExecutor redo = new RedoCommandExecutor();
    private final CutCommandExecutor cut = new CutCommandExecutor();
    private final CopyCommandExecutor copy = new CopyCommandExecutor();
    private final PasteCommandExecutor paste = new PasteCommandExecutor();
    private final SelectAllCommandExecutor selectAll = new SelectAllCommandExecutor();

    public static void attachPopup(JTextComponent textComponent, CommitTrigger resetUndoHistoryTrigger) {
        new TextComponentPopup(textComponent, resetUndoHistoryTrigger);
    }

    public static void attachPopup(JTextComponent textComponent) {
        new TextComponentPopup(textComponent, null);
    }

    protected TextComponentPopup(JTextComponent textComponent, CommitTrigger resetUndoHistoryTrigger) {
        this.textComponent = textComponent;
        this.resetUndoHistoryTrigger = resetUndoHistoryTrigger;
        this.updatePasteStatusTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextComponentPopup.this.updatePasteStatus();
            }
        });
        this.updatePasteStatusTimer.setCoalesce(true);
        this.updatePasteStatusTimer.setRepeats(false);
        this.updatePasteStatusTimer.setInitialDelay(100);
        this.registerListeners();
        this.registerAccelerators();
    }

    private void registerListeners() {
        this.textComponent.addMouseListener(this);
        this.textComponent.addFocusListener(this);
        this.textComponent.addCaretListener(this);
        this.textComponent.getDocument().addUndoableEditListener(this);
        if (this.resetUndoHistoryTrigger != null) {
            CommitTriggerListener resetUndoHistoryHandler = new CommitTriggerListener(){

                public void commit() {
                    TextComponentPopup.this.undoManager.discardAllEdits();
                    TextComponentPopup.this.updateUndoRedoState();
                }

                public void revert() {
                }
            };
            this.resetUndoHistoryTrigger.addCommitTriggerListener(resetUndoHistoryHandler);
        }
    }

    protected CommandManager getCommandManager() {
        CommandManager commandManager;
        ApplicationWindow appWindow = Application.instance().getActiveWindow();
        if (appWindow == null || appWindow.getCommandManager() == null) {
            if (localCommandManager == null) {
                localCommandManager = new DefaultCommandManager();
            }
            commandManager = localCommandManager;
        } else {
            commandManager = appWindow.getCommandManager();
        }
        for (int i = 0; i < COMMANDS.length; ++i) {
            if (commandManager.containsActionCommand(COMMANDS[i])) continue;
            commandManager.registerCommand(new TargetableActionCommand(COMMANDS[i], null));
        }
        return commandManager;
    }

    public void registerAccelerators() {
        CommandManager commandManager = this.getCommandManager();
        DefaultKeymap keymap = new DefaultKeymap(this.getClass().getName(), this.textComponent.getKeymap());
        for (int i = 0; i < COMMANDS.length; ++i) {
            ActionCommand command = commandManager.getActionCommand(COMMANDS[i]);
            keymap.addActionForKeyStroke(command.getAccelerator(), command.getActionAdapter());
        }
        if (COMMANDS.length > 0) {
            this.textComponent.setKeymap(keymap);
        }
    }

    public void mousePressed(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    private void maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.updatePasteStatusNow();
            this.createPopup().show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void caretUpdate(CaretEvent e) {
        this.updateState();
    }

    public void focusGained(FocusEvent e) {
        this.updateState();
        this.registerCommandExecutors();
    }

    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.unregisterCommandExecutors();
        }
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.addEdit(e.getEdit());
        this.updateUndoRedoState();
    }

    private JPopupMenu createPopup() {
        if (this.textComponent instanceof JPasswordField) {
            return this.getPasswordCommandGroup().createPopupMenu();
        }
        if (this.isEditable()) {
            return this.getEditableCommandGroup().createPopupMenu();
        }
        return this.getReadOnlyCommandGroup().createPopupMenu();
    }

    private void updateState() {
        boolean hasSelection = this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd();
        this.copy.setEnabled(hasSelection);
        this.selectAll.setEnabled(this.textComponent.getDocument().getLength() > 0);
        boolean isEditable = this.isEditable();
        this.cut.setEnabled(hasSelection && isEditable);
        if (isEditable) {
            this.scheduleUpdatePasteStatus();
        } else {
            this.paste.setEnabled(false);
        }
        this.updateUndoRedoState();
    }

    private void updateUndoRedoState() {
        this.undo.setEnabled(this.undoManager.canUndo());
        this.redo.setEnabled(this.undoManager.canRedo());
    }

    private void scheduleUpdatePasteStatus() {
        if (!this.updatePasteStatusTimer.isRunning()) {
            this.updatePasteStatusTimer.restart();
        }
    }

    private void updatePasteStatusNow() {
        if (this.updatePasteStatusTimer.isRunning()) {
            this.updatePasteStatusTimer.stop();
        }
        this.updatePasteStatus();
    }

    private void updatePasteStatus() {
        this.paste.setEnabled(this.isEditable() && this.canPasteFromClipboard());
    }

    private boolean canPasteFromClipboard() {
        try {
            return this.textComponent.getTransferHandler().canImport(this.textComponent, Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this.textComponent).getTransferDataFlavors());
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private boolean isEditable() {
        return !(this.textComponent instanceof JPasswordField) && this.textComponent.isEnabled() && this.textComponent.isEditable();
    }

    protected CommandGroup getEditableCommandGroup() {
        CommandGroup editGroup = this.getCommandManager().getCommandGroup("textEditMenu");
        if (editGroup == null) {
            editGroup = this.getCommandManager().createCommandGroup("textEditMenu", new Object[]{"undoCommand", "redoCommand", "separator", "cutCommand", "copyCommand", "pasteCommand", "separator", "selectAllCommand"});
        }
        return editGroup;
    }

    protected CommandGroup getPasswordCommandGroup() {
        CommandGroup passwordGroup = this.getCommandManager().getCommandGroup("passwordTextEditMenu");
        if (passwordGroup == null) {
            passwordGroup = this.getCommandManager().createCommandGroup("passwordTextEditMenu", new Object[]{"undoCommand", "redoCommand"});
        }
        return passwordGroup;
    }

    protected CommandGroup getReadOnlyCommandGroup() {
        CommandGroup readOnlyGroup = this.getCommandManager().getCommandGroup("readOnlyTextEditMenu");
        if (readOnlyGroup == null) {
            readOnlyGroup = this.getCommandManager().createCommandGroup("readOnlyTextEditMenu", new Object[]{"copyCommand", "separator", "selectAllCommand"});
        }
        return readOnlyGroup;
    }

    private void registerCommandExecutors() {
        CommandManager commandManager = this.getCommandManager();
        commandManager.setTargetableActionCommandExecutor("undoCommand", this.undo);
        commandManager.setTargetableActionCommandExecutor("redoCommand", this.redo);
        commandManager.setTargetableActionCommandExecutor("cutCommand", this.cut);
        commandManager.setTargetableActionCommandExecutor("copyCommand", this.copy);
        commandManager.setTargetableActionCommandExecutor("pasteCommand", this.paste);
        commandManager.setTargetableActionCommandExecutor("selectAllCommand", this.selectAll);
    }

    private void unregisterCommandExecutors() {
        CommandManager commandManager = this.getCommandManager();
        commandManager.setTargetableActionCommandExecutor("undoCommand", null);
        commandManager.setTargetableActionCommandExecutor("redoCommand", null);
        commandManager.setTargetableActionCommandExecutor("cutCommand", null);
        commandManager.setTargetableActionCommandExecutor("copyCommand", null);
        commandManager.setTargetableActionCommandExecutor("pasteCommand", null);
        commandManager.setTargetableActionCommandExecutor("selectAllCommand", null);
    }

    public static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable bindings;
        Action defaultAction;

        DefaultKeymap(String nm, Keymap parent) {
            this.nm = nm;
            this.parent = parent;
            this.bindings = new Hashtable();
        }

        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            return this.parent != null ? this.parent.getDefaultAction() : null;
        }

        public void setDefaultAction(Action a) {
            this.defaultAction = a;
        }

        public String getName() {
            return this.nm;
        }

        public Action getAction(KeyStroke key) {
            Action a = (Action)this.bindings.get(key);
            if (a == null && this.parent != null) {
                a = this.parent.getAction(key);
            }
            return a;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keys = new KeyStroke[this.bindings.size()];
            int i = 0;
            Enumeration e = this.bindings.keys();
            while (e.hasMoreElements()) {
                keys[i++] = (KeyStroke)e.nextElement();
            }
            return keys;
        }

        public Action[] getBoundActions() {
            Action[] actions = new Action[this.bindings.size()];
            int i = 0;
            Enumeration e = this.bindings.elements();
            while (e.hasMoreElements()) {
                actions[i++] = (Action)e.nextElement();
            }
            return actions;
        }

        public KeyStroke[] getKeyStrokesForAction(Action a) {
            KeyStroke[] pStrokes;
            if (a == null) {
                return null;
            }
            Object[] retValue = null;
            Vector keyStrokes = null;
            Enumeration enum_ = this.bindings.keys();
            while (enum_.hasMoreElements()) {
                Object key = enum_.nextElement();
                if (this.bindings.get(key) != a) continue;
                if (keyStrokes == null) {
                    keyStrokes = new Vector();
                }
                keyStrokes.addElement(key);
            }
            if (this.parent != null && (pStrokes = this.parent.getKeyStrokesForAction(a)) != null) {
                int counter;
                int rCount = 0;
                for (counter = pStrokes.length - 1; counter >= 0; --counter) {
                    if (!this.isLocallyDefined(pStrokes[counter])) continue;
                    pStrokes[counter] = null;
                    ++rCount;
                }
                if (rCount > 0 && rCount < pStrokes.length) {
                    if (keyStrokes == null) {
                        keyStrokes = new Vector();
                    }
                    for (counter = pStrokes.length - 1; counter >= 0; --counter) {
                        if (pStrokes[counter] == null) continue;
                        keyStrokes.addElement(pStrokes[counter]);
                    }
                } else if (rCount == 0) {
                    if (keyStrokes == null) {
                        retValue = pStrokes;
                    } else {
                        retValue = new KeyStroke[keyStrokes.size() + pStrokes.length];
                        keyStrokes.copyInto(retValue);
                        System.arraycopy(pStrokes, 0, retValue, keyStrokes.size(), pStrokes.length);
                        keyStrokes = null;
                    }
                }
            }
            if (keyStrokes != null) {
                retValue = new KeyStroke[keyStrokes.size()];
                keyStrokes.copyInto(retValue);
            }
            return retValue;
        }

        public boolean isLocallyDefined(KeyStroke key) {
            return this.bindings.containsKey(key);
        }

        public void addActionForKeyStroke(KeyStroke key, Action a) {
            this.bindings.put(key, a);
        }

        public void removeKeyStrokeBinding(KeyStroke key) {
            this.bindings.remove(key);
        }

        public void removeBindings() {
            this.bindings.clear();
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void setResolveParent(Keymap parent) {
            this.parent = parent;
        }

        public String toString() {
            return "Keymap[" + this.nm + "]" + this.bindings;
        }
    }

    private class SelectAllCommandExecutor
    extends AbstractActionCommandExecutor {
        private SelectAllCommandExecutor() {
        }

        public void execute() {
            TextComponentPopup.this.textComponent.selectAll();
        }
    }

    private class PasteCommandExecutor
    extends AbstractActionCommandExecutor {
        private PasteCommandExecutor() {
        }

        public void execute() {
            TextComponentPopup.this.textComponent.paste();
        }
    }

    private class CopyCommandExecutor
    extends AbstractActionCommandExecutor {
        private CopyCommandExecutor() {
        }

        public void execute() {
            TextComponentPopup.this.textComponent.copy();
        }
    }

    private class CutCommandExecutor
    extends AbstractActionCommandExecutor {
        private CutCommandExecutor() {
        }

        public void execute() {
            TextComponentPopup.this.textComponent.cut();
        }
    }

    private class RedoCommandExecutor
    extends AbstractActionCommandExecutor {
        private RedoCommandExecutor() {
        }

        public void execute() {
            TextComponentPopup.this.undoManager.redo();
        }
    }

    private class UndoCommandExecutor
    extends AbstractActionCommandExecutor {
        private UndoCommandExecutor() {
        }

        public void execute() {
            TextComponentPopup.this.undoManager.undo();
        }
    }
}

