/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.text;

public abstract class TimeFormat {
    private static final TimeFormat daysInstance = new TimeFormat(){

        public String format(long time) {
            int totalSeconds = (int)time / 1000;
            int days = totalSeconds / 86400;
            int dSecs = days * 86400;
            int hours = (totalSeconds - dSecs) / 3600;
            int hSecs = hours * 3600;
            int minutes = (totalSeconds - dSecs - hSecs) / 60;
            int mSecs = minutes * 60;
            int seconds = totalSeconds - dSecs - hSecs - mSecs;
            StringBuffer buf = new StringBuffer();
            if (days > 0) {
                buf.append(days);
                buf.append("d ");
            }
            buf.append(hours);
            buf.append("h ");
            buf.append(minutes);
            buf.append("m ");
            buf.append(seconds);
            buf.append("s");
            return buf.toString();
        }
    };
    private static final TimeFormat millisecondsInstance = new TimeFormat(){

        public String format(long time) {
            int totalSeconds = (int)time / 1000;
            int days = totalSeconds / 86400;
            int dSecs = days * 86400;
            int hours = (totalSeconds - dSecs) / 3600;
            int hSecs = hours * 3600;
            int minutes = (totalSeconds - dSecs - hSecs) / 60;
            int mSecs = minutes * 60;
            int seconds = totalSeconds - dSecs - hSecs - mSecs;
            long milliseconds = time - (long)(dSecs * 1000) - (long)(hSecs * 1000) - (long)(mSecs * 1000) - (long)(seconds * 1000);
            StringBuffer buf = new StringBuffer();
            if (days > 0) {
                buf.append(days);
                buf.append("d ");
            }
            if (hours > 0) {
                buf.append(hours);
                buf.append("h ");
            }
            if (minutes > 0) {
                buf.append(minutes);
                buf.append("m ");
            }
            if (seconds > 0) {
                buf.append(seconds);
                buf.append("s ");
            }
            if (milliseconds > 0L) {
                buf.append(milliseconds);
                buf.append("ms");
            }
            if (buf.length() == 0) {
                return "0";
            }
            return buf.toString();
        }
    };

    public static synchronized TimeFormat getDaysInstance() {
        return daysInstance;
    }

    public static synchronized TimeFormat getMillisecondsInstance() {
        return millisecondsInstance;
    }

    public abstract String format(long var1);
}

