/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.core.style.StylerUtils;

public class ClassUtils {
    private static final Log logger = LogFactory.getLog(ClassUtils.class);
    private static Set simpleClasses = new HashSet();
    private static final Map primativeToWrapperMap;

    private ClassUtils() {
    }

    public static void initializeClass(Class clazz) {
        try {
            Class.forName(clazz.getName(), true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getClassFieldNameWithValue(Class clazz, Object value) {
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                Object constant = field.get(null);
                if (!value.equals(constant)) continue;
                return clazz.getName() + "." + field.getName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Object getFieldValue(String qualifiedFieldName) {
        Class clazz;
        try {
            clazz = ClassUtils.classForName(ClassUtils.qualifier(qualifiedFieldName));
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        try {
            return clazz.getField(ClassUtils.unqualify(qualifiedFieldName)).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static Method findMethod(String methodName, Class clazz, Class[] parmTypes) {
        try {
            return clazz.getMethod(methodName, parmTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static String unqualify(String qualifiedName) {
        return ClassUtils.unqualify(qualifiedName, '.');
    }

    public static String unqualify(Class clazz) {
        return ClassUtils.unqualify(clazz.getName());
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String qualifier(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        if (loc < 0) {
            return "";
        }
        return qualifiedName.substring(0, loc);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isSimpleScalar(Class clazz) {
        return clazz.isPrimitive() || simpleClasses.contains(clazz) || LabeledEnum.class.isAssignableFrom(clazz);
    }

    public static Method getStaticMethod(String name, Class locatorClass, Class[] args) {
        try {
            logger.debug((Object)("Attempting to get method '" + name + "' on class " + locatorClass + " with arguments '" + StylerUtils.style((Object)args) + "'"));
            Method method = locatorClass.getDeclaredMethod(name, args);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Class convertPrimitiveToWrapper(Class clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return clazz;
        }
        return (Class)primativeToWrapperMap.get(clazz);
    }

    public static Object getValueFromMapForClass(Class typeClass, Map classMap) {
        Object val = classMap.get(typeClass);
        if (val == null) {
            val = ClassUtils.getValueFromMapForInterfaces(typeClass, classMap);
            if (val == null) {
                val = ClassUtils.getValueFromMapForSuperClass(typeClass, classMap);
            }
            if (val == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find a definition for " + typeClass + " in " + classMap.keySet()));
                }
                return null;
            }
            classMap.put(typeClass, val);
            return val;
        }
        return val;
    }

    private static Object getValueFromMapForInterfaces(Class typeClass, Map classMap) {
        Object val;
        Class<?> anInterface;
        int i;
        Class<?>[] interfaces = typeClass.getInterfaces();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searching through " + Arrays.asList(interfaces)));
        }
        for (i = 0; i < interfaces.length; ++i) {
            anInterface = interfaces[i];
            val = classMap.get(anInterface);
            if (val == null) continue;
            return val;
        }
        for (i = 0; i < interfaces.length; ++i) {
            anInterface = interfaces[i];
            val = ClassUtils.getValueFromMapForInterfaces(anInterface, classMap);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private static Object getValueFromMapForSuperClass(Class typeClass, Map classMap) {
        for (Class superClass = typeClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            Object val;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("searching for " + superClass));
            }
            if ((val = classMap.get(superClass)) != null) {
                return val;
            }
            val = ClassUtils.getValueFromMapForInterfaces(superClass, classMap);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public static boolean isAProperty(Class theClass, String propertyName) {
        if (theClass == null) {
            throw new IllegalArgumentException("theClass == null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName == null");
        }
        if (ClassUtils.getReadMethod(theClass, propertyName) != null) {
            return true;
        }
        return ClassUtils.getWriteMethod(theClass, propertyName) != null;
    }

    private static Method getReadMethod(Class theClass, String propertyName) {
        if (propertyName.indexOf(46) > -1) {
            int index = propertyName.indexOf(46);
            String firstPropertyName = propertyName.substring(0, index);
            String restOfPropertyName = propertyName.substring(index + 1, propertyName.length());
            Class firstPropertyClass = ClassUtils.getPropertyClass(theClass, firstPropertyName);
            return ClassUtils.getReadMethod(firstPropertyClass, restOfPropertyName);
        }
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + (propertyName.length() == 1 ? "" : propertyName.substring(1));
        Method method = ClassUtils.getMethod(theClass, getterName);
        if (method == null) {
            String isserName = "is" + propertyName.substring(0, 1).toUpperCase() + (propertyName.length() == 1 ? "" : propertyName.substring(1));
            method = ClassUtils.getMethod(theClass, isserName);
        }
        if (method == null) {
            logger.info((Object)("There is not a getter for " + propertyName + " in " + theClass));
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            logger.warn((Object)("The getter for " + propertyName + " in " + theClass + " is not public: " + method));
            return null;
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            logger.warn((Object)("The getter for " + propertyName + " in " + theClass + " returns void: " + method));
            return null;
        }
        if (method.getName().startsWith("is") && !Boolean.class.equals(method.getReturnType()) && !Boolean.TYPE.equals(method.getReturnType())) {
            logger.warn((Object)("The getter for " + propertyName + " in " + theClass + " uses the boolean naming convention but is not boolean: " + method));
            return null;
        }
        return method;
    }

    private static Method getMethod(Class theClass, String getterName) {
        try {
            return theClass.getMethod(getterName, null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getWriteMethod(Class theClass, String propertyName) {
        if (propertyName.indexOf(46) > -1) {
            int index = propertyName.indexOf(46);
            String firstPropertyName = propertyName.substring(0, index);
            String restOfPropertyName = propertyName.substring(index + 1, propertyName.length());
            Class firstPropertyClass = ClassUtils.getPropertyClass(theClass, firstPropertyName);
            return ClassUtils.getWriteMethod(firstPropertyClass, restOfPropertyName);
        }
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + (propertyName.length() == 1 ? "" : propertyName.substring(1));
        Method[] methods = theClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!setterName.equals(method.getName()) || method.getParameterTypes().length != 1) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                logger.warn((Object)("The setter for " + propertyName + " in " + theClass + " is not public: " + method));
                return null;
            }
            if (!Void.TYPE.equals(method.getReturnType())) {
                logger.warn((Object)("The setter for " + propertyName + " in " + theClass + " is not void: " + method));
                return null;
            }
            return method;
        }
        logger.info((Object)("There is not a setter for " + propertyName + " in " + theClass));
        return null;
    }

    public static Class getPropertyClass(Class parentClass, String propertyName) throws IllegalArgumentException {
        if (parentClass == null) {
            throw new IllegalArgumentException("theClass == null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName == null");
        }
        Method getterMethod = ClassUtils.getReadMethod(parentClass, propertyName);
        if (getterMethod != null) {
            return getterMethod.getReturnType();
        }
        Method setterMethod = ClassUtils.getWriteMethod(parentClass, propertyName);
        if (setterMethod != null) {
            return setterMethod.getParameterTypes()[0];
        }
        throw new IllegalArgumentException(propertyName + " is not a property of " + parentClass);
    }

    static {
        simpleClasses.add(String.class);
        simpleClasses.add(Integer.class);
        simpleClasses.add(Float.class);
        simpleClasses.add(Double.class);
        simpleClasses.add(Long.class);
        simpleClasses.add(Short.class);
        simpleClasses.add(Byte.class);
        simpleClasses.add(BigInteger.class);
        simpleClasses.add(java.util.Date.class);
        simpleClasses.add(Date.class);
        simpleClasses.add(Class.class);
        simpleClasses.add(Boolean.class);
        simpleClasses.add(Timestamp.class);
        simpleClasses.add(Calendar.class);
        simpleClasses.add(URL.class);
        simpleClasses.add(InetAddress.class);
        primativeToWrapperMap = new HashMap();
        primativeToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primativeToWrapperMap.put(Character.TYPE, Character.class);
        primativeToWrapperMap.put(Byte.TYPE, Byte.class);
        primativeToWrapperMap.put(Short.TYPE, Short.class);
        primativeToWrapperMap.put(Integer.TYPE, Integer.class);
        primativeToWrapperMap.put(Long.TYPE, Long.class);
        primativeToWrapperMap.put(Float.TYPE, Float.class);
        primativeToWrapperMap.put(Double.TYPE, Double.class);
    }
}

