/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.springframework.util.Assert;

public class PopupMenuMouseListener
extends MouseAdapter {
    private JPopupMenu popupMenu;

    protected PopupMenuMouseListener() {
    }

    public PopupMenuMouseListener(JPopupMenu popupMenu) {
        Assert.notNull((Object)popupMenu);
        this.popupMenu = popupMenu;
    }

    protected boolean onAboutToShow(MouseEvent e) {
        return true;
    }

    protected void showPopupMenu(MouseEvent e) {
        if (this.onAboutToShow(e)) {
            JPopupMenu popupToShow = this.getPopupMenu(e);
            if (popupToShow == null) {
                return;
            }
            popupToShow.show(e.getComponent(), e.getX(), e.getY());
            popupToShow.setVisible(true);
        }
    }

    protected JPopupMenu getPopupMenu(MouseEvent e) {
        return this.getPopupMenu();
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            throw new UnsupportedOperationException("One of the getPopupMenu methods must be overridden when default constructor is used.");
        }
        return this.popupMenu;
    }

    public void mousePressed(MouseEvent e) {
        this.checkEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.checkEvent(e);
    }

    private void checkEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e);
        }
    }
}

