/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import org.springframework.richclient.util.Assert;

public class WindowUtils {
    private WindowUtils() {
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Point getCenteringPointOnScreen(Dimension dimension) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > screen.width) {
            dimension.width = screen.width;
        }
        if (dimension.height > screen.height) {
            dimension.height = screen.height;
        }
        return new Point((screen.width - dimension.width) / 2, (screen.height - dimension.height) / 2);
    }

    public static void centerOnScreenAndSetVisible(Window window) {
        window.pack();
        WindowUtils.centerOnScreen(window);
        window.setVisible(true);
    }

    public static void centerOnScreen(Window window) {
        Assert.notNull((Object)window, (String)"window cannot be null");
        try {
            Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension windowSize = window.getSize();
            int x = screenBounds.x + (screenBounds.width - windowSize.width) / 2;
            int y = screenBounds.y + (screenBounds.height - windowSize.height) / 2;
            window.setLocation(x, y);
        }
        catch (Throwable t) {
            window.setLocationRelativeTo(window);
        }
    }

    public static void centerOnParentAndSetVisible(Window window) {
        window.pack();
        WindowUtils.centerOnParent(window, window.getParent());
        window.setVisible(true);
    }

    public static void centerOnParent(Window window, Component parent) {
        if (parent == null || !parent.isShowing()) {
            WindowUtils.centerOnScreen(window);
        } else {
            window.setLocationRelativeTo(parent);
        }
    }

    public static final Dimension getDimensionFromPercent(int percentWidth, int percentHeight) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return WindowUtils.calcDimensionFromPercent(screenSize, percentWidth, percentHeight);
    }

    private static Dimension calcDimensionFromPercent(Dimension dimension, int percentWidth, int percentHeight) {
        int width = dimension.width * percentWidth / 100;
        int height = dimension.height * percentHeight / 100;
        return new Dimension(width, height);
    }

    public static int getScreenWidth() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return screenSize.width;
    }

    public static int getScreenHeight() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return screenSize.height;
    }
}

