/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.dialog.TitlePane;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.AbstractWidgetForm;
import org.springframework.richclient.widget.TitledWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTitledWidgetForm
extends AbstractWidgetForm
implements TitledWidget {
    private Message description = new DefaultMessage(RcpSupport.getMessage("titledWidget", "defaultMessage", "text"), Severity.INFO);
    private TitlePane titlePane = new TitlePane(2);

    public AbstractTitledWidgetForm(FormModel model) {
        super(model);
    }

    public AbstractTitledWidgetForm(FormModel model, String formId) {
        super(model, formId);
    }

    @Override
    public void setTitle(String title) {
        this.titlePane.setTitle(title);
    }

    @Override
    public void setImage(Image image) {
        this.titlePane.setImage(image);
    }

    @Override
    public void setMessage(Message message) {
        if (message != null) {
            this.titlePane.setMessage(message);
        } else {
            this.titlePane.setMessage(this.getDescription());
        }
    }

    protected Message getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String longDescription) {
        this.description = new DefaultMessage(longDescription);
        this.setMessage(this.description);
    }

    @Override
    public JComponent getComponent() {
        JPanel titlePaneContainer = new JPanel(new BorderLayout());
        titlePaneContainer.add(this.titlePane.getControl());
        titlePaneContainer.add((Component)new JSeparator(), "South");
        JPanel pageControl = new JPanel(new BorderLayout());
        pageControl.add((Component)titlePaneContainer, "North");
        JComponent content = this.createFormControl();
        GuiStandardUtils.attachDialogBorder(content);
        pageControl.add(content);
        this.setMessage(this.getDescription());
        return pageControl;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.titlePane.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String txt, PropertyChangeListener listener) {
        this.titlePane.addPropertyChangeListener(txt, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.titlePane.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String txt, PropertyChangeListener listener) {
        this.titlePane.removePropertyChangeListener(txt, listener);
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public List<? extends AbstractCommand> getCommands() {
        return Collections.emptyList();
    }

    @Override
    public void onAboutToHide() {
    }

    @Override
    public void onAboutToShow() {
    }

    @Override
    public void setCaption(String shortDescription) {
        this.setTitle(shortDescription);
    }

    public void setBeanName(String name) {
        this.setId(name);
    }
}

