/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.widget.AbstractWidget;

public class ButtonSwitcherWidget
extends AbstractWidget {
    private final CardLayout switcher;
    private final JPanel panel;
    public static final String DEFAULT = "default";
    public static final String ALTERNATIVE = "alternative";

    public ButtonSwitcherWidget(AbstractCommand command, String alternativeFaceId) {
        AbstractButton defaultButton = command.createButton();
        AbstractButton alternButton = command.createButton(alternativeFaceId);
        this.switcher = new CardLayout();
        this.panel = new JPanel(this.switcher);
        this.panel.add((Component)defaultButton, DEFAULT);
        this.panel.add((Component)alternButton, ALTERNATIVE);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void showDefault() {
        this.switcher.first(this.panel);
    }

    public void showAlternative() {
        this.switcher.last(this.panel);
    }

    public void show(String mode) {
        this.switcher.show(this.panel, mode);
    }
}

