/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget;

import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.core.io.Resource;
import org.springframework.richclient.widget.AbstractWidget;

public class ImageViewWidget
extends AbstractWidget {
    private JLabel imageHolder = new JLabel();
    private JComponent mainComponent = this.imageHolder;
    private boolean hasContent = true;

    public ImageViewWidget() {
    }

    public ImageViewWidget(Resource resource) {
        this();
        this.setImage(resource);
    }

    public ImageViewWidget(ImageIcon image) {
        this();
        this.setImage(image);
    }

    public void setImage(Resource resource) {
        ImageIcon image = null;
        if (resource != null && resource.exists()) {
            try {
                image = new ImageIcon(resource.getURL());
            }
            catch (IOException e) {
                this.logger.warn((Object)("Error reading resource: " + resource));
                throw new RuntimeException("Error reading resource " + resource, e);
            }
        }
        this.setImage(image);
    }

    public void setImage(ImageIcon image) {
        this.imageHolder.setIcon(image);
        this.hasContent = image != null;
    }

    public JComponent getComponent() {
        return this.hasContent ? this.mainComponent : new JPanel();
    }
}

