/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingworker.SwingWorker;
import org.springframework.binding.validation.support.DefaultValidationMessage;
import org.springframework.binding.validation.support.DefaultValidationResultsModel;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.session.ApplicationSession;
import org.springframework.richclient.application.statusbar.StatusBar;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.form.AbstractForm;
import org.springframework.richclient.form.FilterForm;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.AbstractWidget;
import org.springframework.richclient.widget.Widget;
import org.springframework.richclient.widget.editor.AbstractDataEditorWidget;
import org.springframework.richclient.widget.editor.provider.DataProvider;
import org.springframework.richclient.widget.editor.provider.DataProviderEvent;
import org.springframework.richclient.widget.editor.provider.DataProviderListener;
import org.springframework.richclient.widget.editor.provider.MaximumRowsExceededException;
import org.springframework.richclient.widget.table.TableDescription;
import org.springframework.richclient.widget.table.TableWidget;
import org.springframework.richclient.widget.table.glazedlists.GlazedListTableWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDataEditorWidget
extends AbstractDataEditorWidget
implements DataProviderListener,
PropertyChangeListener {
    private static Log log = LogFactory.getLog(DefaultDataEditorWidget.class);
    private AbstractForm detailForm;
    private FilterForm filterForm;
    private TableWidget tableWidget;
    public static final String PARAMETER_MAP = "dataEditorParameters";
    public static final String PARAMETER_FILTER = "filter";
    public static final String PARAMETER_DEFAULT_SELECTED_OBJECT = "defaultSelectedObject";
    private DataProvider dataProvider;
    private final DefaultValidationResultsModel validationResultsModel = new DefaultValidationResultsModel();
    private ListRetrievingWorker listWorker;
    private final MaximumRowsExceededMessage maximumRowsExceededMessage = new MaximumRowsExceededMessage();

    protected void listWorkerDone(List<Object> rows, Map<String, Object> parameters) {
        this.setRows(rows);
        this.validationResultsModel.removeMessage(this.maximumRowsExceededMessage);
        if (rows == null || rows.size() == 0) {
            return;
        }
        Object defaultSelectedObject = null;
        if (parameters.containsKey(PARAMETER_DEFAULT_SELECTED_OBJECT)) {
            defaultSelectedObject = parameters.get(PARAMETER_DEFAULT_SELECTED_OBJECT);
        }
        if (defaultSelectedObject == null) {
            this.tableWidget.selectRowObject(0, (Observer)null);
        } else {
            this.tableWidget.selectRowObject(defaultSelectedObject, null);
        }
    }

    public DefaultDataEditorWidget() {
    }

    public DefaultDataEditorWidget(String id, DataProvider provider) {
        this(id, provider, null, null, null);
    }

    public DefaultDataEditorWidget(DataProvider provider, AbstractForm form, TableDescription tableDesc, FilterForm filterForm) {
        this(null, provider, form, tableDesc, filterForm);
    }

    public DefaultDataEditorWidget(String id, DataProvider provider, AbstractForm form, TableDescription tableDesc, FilterForm filterForm) {
        this.setId(id);
        this.setDataProvider(provider);
        this.setDetailForm(form);
        this.setTableWidget(tableDesc);
        this.setFilterForm(filterForm);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.tableWidget.getTable().setName(title);
    }

    @Override
    public Widget createDetailWidget() {
        return new AbstractWidget(){

            @Override
            public void onAboutToShow() {
                DefaultDataEditorWidget.this.onAboutToShow();
            }

            @Override
            public void onAboutToHide() {
                DefaultDataEditorWidget.this.onAboutToHide();
            }

            @Override
            public JComponent getComponent() {
                return DefaultDataEditorWidget.this.getDetailForm().getControl();
            }

            @Override
            public List<? extends AbstractCommand> getCommands() {
                return Arrays.asList(DefaultDataEditorWidget.this.getDetailForm().getCommitCommand());
            }
        };
    }

    protected void setDetailForm(AbstractForm detailForm) {
        if (this.detailForm != null) {
            this.validationResultsModel.remove(this.detailForm.getFormModel().getValidationResults());
        }
        this.detailForm = detailForm;
        if (this.detailForm != null) {
            this.validationResultsModel.add(this.detailForm.getFormModel().getValidationResults());
        }
    }

    @Override
    public AbstractForm getDetailForm() {
        return this.detailForm;
    }

    protected void setFilterForm(FilterForm filterForm) {
        if (this.filterForm != null) {
            this.validationResultsModel.remove(this.filterForm.getFormModel().getValidationResults());
        }
        this.filterForm = filterForm;
        if (this.filterForm != null) {
            this.validationResultsModel.add(filterForm.getFormModel().getValidationResults());
        }
    }

    @Override
    public FilterForm getFilterForm() {
        return this.filterForm;
    }

    public void setFilterModel(Object model) {
        this.getFilterForm().setFormObject(model);
    }

    protected void setTableWidget(TableDescription tableDescription) {
        if (tableDescription != null) {
            GlazedListTableWidget tableWidget = new GlazedListTableWidget(null, tableDescription);
            this.setTableWidget(tableWidget);
        }
    }

    protected void setTableWidget(TableWidget tableWidget) {
        if (this.tableWidget != null) {
            this.tableWidget.removeSelectionObserver(this.tableSelectionObserver);
        }
        this.tableWidget = tableWidget;
        if (this.tableWidget != null) {
            this.tableWidget.addSelectionObserver(this.tableSelectionObserver);
        }
    }

    @Override
    public TableWidget getTableWidget() {
        return this.tableWidget;
    }

    protected void setDataProvider(DataProvider provider) {
        if (this.dataProvider != null && this.dataProvider.getRefreshPolicy() == DataProvider.RefreshPolicy.ON_USER_SWITCH) {
            ApplicationSession.getSession().removePropertyChangeListener("user", this);
        }
        this.dataProvider = provider;
        if (this.dataProvider != null && this.dataProvider.getRefreshPolicy() == DataProvider.RefreshPolicy.ON_USER_SWITCH) {
            ApplicationSession.getSession().addPropertyChangeListener("user", this);
        }
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    protected boolean isUpdateRowSupported() {
        return this.dataProvider.supportsUpdate();
    }

    @Override
    protected boolean isAddRowSupported() {
        return this.dataProvider.supportsCreate();
    }

    @Override
    protected boolean isCloneRowSupported() {
        return this.dataProvider.supportsClone() && this.dataProvider.supportsCreate();
    }

    @Override
    protected boolean isFilterSupported() {
        return this.dataProvider.supportsFiltering();
    }

    @Override
    protected boolean isRemoveRowsSupported() {
        return this.dataProvider.supportsDelete();
    }

    @Override
    public synchronized void executeFilter(Map<String, Object> parameters) {
        if (this.listWorker == null) {
            if (this.dataProvider.supportsBaseCriteria()) {
                this.dataProvider.setBaseCriteria(this.getBaseCriteria());
            }
            StatusBar statusBar = Application.instance().getActiveWindow().getStatusBar();
            statusBar.getProgressMonitor().taskStarted(RcpSupport.getMessage("statusBar", "loadTable", "label"), -1);
            this.listWorker = new ListRetrievingWorker();
            if (this.dataProvider.supportsFiltering()) {
                if (parameters.containsKey(PARAMETER_FILTER)) {
                    this.setFilterModel(parameters.get(PARAMETER_FILTER));
                }
                this.listWorker.filterCriteria = this.getFilterForm().getFilterCriteria();
            }
            this.listWorker.parameters = parameters;
            log.debug((Object)("Execute Filter with criteria: " + this.listWorker.filterCriteria + " and parameters: " + parameters));
            this.listWorker.execute();
        }
    }

    @Override
    public void executeFilter() {
        this.executeFilter(Collections.EMPTY_MAP);
    }

    protected List getList(Object criteria) {
        if (this.dataProvider.supportsBaseCriteria()) {
            this.dataProvider.setBaseCriteria(this.getBaseCriteria());
        }
        try {
            List dataSet = this.dataProvider.getList(criteria);
            this.setRows(dataSet);
            this.setMessage(null);
            return dataSet;
        }
        catch (MaximumRowsExceededException mre) {
            this.setRows(Collections.EMPTY_LIST);
            this.setMessage(new DefaultMessage(this.getMessage("MaximumRowsExceededException.notice", new Object[]{mre.getNumberOfRows(), mre.getMaxRows()}), Severity.WARNING));
            if (this.getToggleFilterCommand() != null) {
                this.getToggleFilterCommand().doShow();
            }
            return null;
        }
    }

    protected void setRows(List dataSet) {
        this.tableWidget.setRows(dataSet);
    }

    protected Object getBaseCriteria() {
        return null;
    }

    @Override
    protected Object loadEntityDetails(Object baseObject, boolean forceLoad) {
        return this.dataProvider.getDetailObject(baseObject, forceLoad);
    }

    public Object loadSimpleEntity(Object baseObject) {
        Object returnValue = this.dataProvider.getSimpleObject(baseObject);
        if (returnValue == null) {
            throw new NullPointerException("Returnvalue for dataprovider simple was null");
        }
        return returnValue;
    }

    @Override
    protected Object saveEntity(Object dirtyObject) {
        if (!this.dataProvider.supportsUpdate()) {
            return null;
        }
        return this.dataProvider.update(dirtyObject);
    }

    @Override
    protected void newRow(Object newClone) {
        if (newClone == null) {
            super.newRow(this.getDataProvider().newInstance(this.getFilterForm() == null ? null : this.getFilterForm().getFormObject()));
        } else {
            super.newRow(newClone);
        }
    }

    @Override
    protected Object createNewEntity(Object newObject) {
        if (!this.dataProvider.supportsCreate()) {
            return null;
        }
        return this.dataProvider.create(newObject);
    }

    @Override
    protected Object cloneEntity(Object sampleObject) {
        if (!this.dataProvider.supportsClone()) {
            return null;
        }
        return this.dataProvider.clone(sampleObject);
    }

    @Override
    protected void removeEntity(Object objectToRemove) {
        if (!this.dataProvider.supportsDelete()) {
            return;
        }
        this.dataProvider.delete(objectToRemove);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof DataProviderEvent) {
            DataProviderEvent obsAct = (DataProviderEvent)arg;
            int act = obsAct.getEventType();
            if (act == 1) {
                this.tableWidget.addRowObject(obsAct.getNewEntity());
            } else if (act == 2) {
                this.replaceRowObject(obsAct.getOldEntity(), obsAct.getNewEntity());
            } else if (act == 3) {
                this.tableWidget.removeRowObject(obsAct.getOldEntity());
            }
        }
    }

    @Override
    public void onAboutToShow() {
        log.debug((Object)(this.getId() + ": onAboutToShow with refreshPolicy: " + (Object)((Object)this.dataProvider.getRefreshPolicy())));
        super.onAboutToShow();
        this.dataProvider.addDataProviderListener(this);
        this.registerListeners();
        if (this.detailForm instanceof Widget) {
            ((Widget)((Object)this.detailForm)).onAboutToShow();
        }
        this.tableWidget.onAboutToShow();
        if (this.dataProvider.getRefreshPolicy() != DataProvider.RefreshPolicy.NEVER && this.tableWidget.isEmpty()) {
            this.executeFilter();
        } else if (!this.tableWidget.hasSelection()) {
            this.tableWidget.selectRowObject(0, (Observer)this);
        }
    }

    @Override
    public void onAboutToHide() {
        log.debug((Object)(this.getId() + ": onAboutToHide with refreshPolicy: " + (Object)((Object)this.dataProvider.getRefreshPolicy())));
        super.onAboutToHide();
        this.dataProvider.removeDataProviderListener(this);
        this.unRegisterListeners();
        if (this.detailForm instanceof Widget) {
            ((Widget)((Object)this.detailForm)).onAboutToHide();
        }
        if (this.dataProvider.getRefreshPolicy() == DataProvider.RefreshPolicy.ALLWAYS) {
            this.getTableWidget().setRows(Collections.EMPTY_LIST);
        }
    }

    protected void registerListeners() {
    }

    protected void unRegisterListeners() {
    }

    @Override
    public Object setSelectedSearch(Object criteria) {
        if (this.tableWidget.getTextFilterField() != null) {
            this.tableWidget.getTextFilterField().setText("");
        }
        if (criteria == null) {
            if (this.dataProvider.supportsFiltering()) {
                this.getFilterForm().getNewFormObjectCommand().execute();
            }
            this.executeFilter();
            return null;
        }
        List resultList = this.getList(criteria);
        if (this.dataProvider.supportsFiltering()) {
            if (resultList == null || resultList.size() > 0) {
                this.getFilterForm().setFormObject(criteria);
            } else {
                this.getFilterForm().getNewFormObjectCommand().execute();
                this.executeFilter();
            }
        }
        if (resultList != null && resultList.size() == 1) {
            return this.loadSimpleEntity(resultList.get(0));
        }
        return resultList;
    }

    public void refreshSelectedObject() {
        Object selected = this.getSelectedRowObject();
        this.getTableWidget().selectRowObject(-1, (Observer)null);
        this.getTableWidget().selectRowObject(selected, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.dataProvider.getRefreshPolicy() == DataProvider.RefreshPolicy.ALLWAYS || this.dataProvider.getRefreshPolicy() == DataProvider.RefreshPolicy.ON_USER_SWITCH) {
            log.debug((Object)("USER changed event, refreshPolicy= " + (Object)((Object)this.dataProvider.getRefreshPolicy())));
            if (evt.getNewValue() == null) {
                this.setRows(Collections.EMPTY_LIST);
            } else if (this.isShowing()) {
                this.executeFilter();
            }
        }
    }

    @Override
    protected final DefaultValidationResultsModel getValidationResults() {
        return this.validationResultsModel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListRetrievingWorker
    extends SwingWorker<List<Object>, String> {
        protected Object filterCriteria;
        protected Map<String, Object> parameters;

        private ListRetrievingWorker() {
        }

        protected List<Object> doInBackground() throws Exception {
            return DefaultDataEditorWidget.this.getDataProvider().getList(this.filterCriteria);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done() {
            block9: {
                try {
                    DefaultDataEditorWidget.this.listWorkerDone((List)this.get(), this.parameters);
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof MaximumRowsExceededException) {
                        MaximumRowsExceededException mre = (MaximumRowsExceededException)e.getCause();
                        DefaultDataEditorWidget.this.setRows(Collections.EMPTY_LIST);
                        DefaultDataEditorWidget.this.validationResultsModel.removeMessage(DefaultDataEditorWidget.this.maximumRowsExceededMessage);
                        DefaultDataEditorWidget.this.maximumRowsExceededMessage.setMessage(DefaultDataEditorWidget.this.getMessage("MaximumRowsExceededException.notice", new Object[]{mre.getNumberOfRows(), mre.getMaxRows()}));
                        DefaultDataEditorWidget.this.validationResultsModel.addMessage(DefaultDataEditorWidget.this.maximumRowsExceededMessage);
                        if (DefaultDataEditorWidget.this.getToggleFilterCommand() != null) {
                            DefaultDataEditorWidget.this.getToggleFilterCommand().doShow();
                        }
                        break block9;
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    Application.instance().getActiveWindow().getStatusBar().getProgressMonitor().done();
                    DefaultDataEditorWidget.this.listWorker = null;
                }
            }
        }
    }

    protected static class MaximumRowsExceededMessage
    extends DefaultValidationMessage {
        private String message;

        public MaximumRowsExceededMessage() {
            super("maximumRowsExceeded", Severity.WARNING, "maximumRowsExceeded");
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

