/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.table;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.richclient.widget.table.Accessor;
import org.springframework.richclient.widget.table.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAccessor
implements Accessor {
    private Accessor wrappedAccessor;
    private final String nestedProperty;
    private final Method getter;

    public NestedAccessor(Class<?> clazz, String propertyName, String nestedPropertyName) {
        this(ClassUtils.getReadMethod(clazz, propertyName), nestedPropertyName);
    }

    public NestedAccessor(Method getter, String nestedProperty) {
        this.nestedProperty = nestedProperty;
        this.getter = getter;
    }

    @Override
    public Object getValue(Object fromEntity) throws IllegalAccessException, InvocationTargetException {
        Object propertyValue = this.getter.invoke(fromEntity, new Object[0]);
        return propertyValue == null ? null : this.getWrappedAccessor(propertyValue.getClass()).getValue(propertyValue);
    }

    private Accessor getWrappedAccessor(Class<?> propertyType) {
        if (this.wrappedAccessor == null) {
            try {
                this.wrappedAccessor = ClassUtils.getAccessorForProperty(this.getter.getReturnType(), this.nestedProperty);
            }
            catch (NoSuchMethodError nsme) {
                if (propertyType == null) {
                    throw nsme;
                }
                this.wrappedAccessor = ClassUtils.getAccessorForProperty(propertyType, this.nestedProperty);
            }
        }
        return this.wrappedAccessor;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.getWrappedAccessor(null).getPropertyType();
    }
}

