/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.widget.table;

import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.FieldMetadata;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.form.AbstractForm;

public class ValueModelTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final FormModel formModel;
    private final ActionCommand commitCommand;
    private final FieldMetadata fieldMetaData;
    private final ValueModel valueModel;
    private final JComponent editor;

    public ValueModelTableCellEditor(FormModel formModel, String propertyName, JComponent editor) {
        this(formModel, formModel.getFieldMetadata(propertyName), formModel.getValueModel(propertyName), editor);
    }

    public ValueModelTableCellEditor(AbstractForm form, String propertyName) {
        this(form.getFormModel(), propertyName, form.getBindingFactory().createBinding(propertyName).getControl());
    }

    public ValueModelTableCellEditor(FormModel formModel, String propertyName, JComponent editor, ActionCommand commitCommand) {
        this(formModel, formModel.getFieldMetadata(propertyName), formModel.getValueModel(propertyName), editor, commitCommand);
    }

    public ValueModelTableCellEditor(FormModel formModel, FieldMetadata fieldMetadata, ValueModel valueModel, JComponent editor) {
        this(formModel, fieldMetadata, valueModel, editor, null);
    }

    public ValueModelTableCellEditor(FormModel formModel, FieldMetadata fieldMetadata, ValueModel valueModel, JComponent editor, ActionCommand commitCommand) {
        this.formModel = formModel;
        this.valueModel = valueModel;
        this.fieldMetaData = fieldMetadata;
        this.editor = editor;
        this.commitCommand = commitCommand;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        TableModel tableModel = table.getModel();
        if (tableModel instanceof EventTableModel) {
            this.formModel.setFormObject(((EventTableModel)tableModel).getElementAt(row));
        }
        if (this.editor instanceof JTextComponent) {
            ((JTextComponent)this.editor).selectAll();
        }
        return this.editor;
    }

    public void cancelCellEditing() {
        this.formModel.revert();
        super.cancelCellEditing();
    }

    public Object getCellEditorValue() {
        return this.valueModel.getValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        if (!this.formModel.isDirty()) {
            return super.stopCellEditing();
        }
        if (this.formModel.isCommittable()) {
            if (this.commitCommand != null) {
                this.commitCommand.execute();
            } else {
                this.formModel.commit();
            }
            return super.stopCellEditing();
        }
        return false;
    }
}

