/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.wizard;

import java.awt.Image;
import javax.swing.JComponent;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.dialog.AbstractDialogPage;
import org.springframework.richclient.wizard.Wizard;
import org.springframework.richclient.wizard.WizardContainer;
import org.springframework.richclient.wizard.WizardPage;

public abstract class AbstractWizardPage
extends AbstractDialogPage
implements WizardPage {
    private Wizard wizard;
    private WizardPage previousPage;

    protected AbstractWizardPage(String pageId) {
        this(pageId, false);
    }

    protected AbstractWizardPage(String pageId, boolean autoConfigure) {
        super(pageId, autoConfigure);
    }

    protected AbstractWizardPage(String pageId, boolean autoConfigure, String title) {
        super(pageId, autoConfigure, title);
    }

    protected AbstractWizardPage(String pageId, boolean autoConfigure, String title, Image icon) {
        super(pageId, autoConfigure, title, icon);
    }

    public String getKey() {
        return this.getWizard().getId() + "." + this.getId();
    }

    public Image getImage() {
        Image image = super.getImage();
        if (image != null) {
            return image;
        }
        return this.wizard.getDefaultPageImage();
    }

    public WizardPage getNextPage() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getNextPage(this);
    }

    public WizardPage getPreviousPage() {
        if (this.previousPage != null) {
            return this.previousPage;
        }
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getPreviousPage(this);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }

    protected boolean isCurrentPage() {
        return this.getContainer() != null && this == this.getContainer().getCurrentPage();
    }

    protected WizardContainer getContainer() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getContainer();
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public void setPreviousPage(WizardPage page) {
        this.previousPage = page;
    }

    public void setVisible(boolean visible) {
        JComponent control = this.getControl();
        if (control != null) {
            super.setVisible(visible);
            control.requestFocusInWindow();
        }
    }

    public void setEnabled(boolean enabled) {
        this.setPageComplete(enabled);
    }

    public void setWizard(Wizard newWizard) {
        Wizard oldValue = this.wizard;
        this.wizard = newWizard;
        this.firePropertyChange("wizard", oldValue, newWizard);
    }

    public void onAboutToShow() {
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).toString();
    }
}

