/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.closure.support;

import org.springframework.rules.closure.Closure;
import org.springframework.rules.closure.ElementGenerator;
import org.springframework.rules.closure.support.Block;
import org.springframework.rules.closure.support.IfBlock;
import org.springframework.rules.closure.support.ProcessStatus;
import org.springframework.rules.constraint.Constraint;

public abstract class AbstractElementGenerator
implements ElementGenerator {
    private ElementGenerator wrappedGenerator;
    private boolean runOnce = false;
    private volatile ProcessStatus status = ProcessStatus.CREATED;

    protected AbstractElementGenerator() {
    }

    protected AbstractElementGenerator(boolean runOnce) {
        this.runOnce = runOnce;
    }

    private AbstractElementGenerator(ElementGenerator wrappedTemplate) {
        this.wrappedGenerator = wrappedTemplate;
    }

    protected ElementGenerator getWrappedTemplate() {
        return this.wrappedGenerator;
    }

    public boolean allTrue(Constraint constraint) {
        WhileTrueController controller = new WhileTrueController(this, constraint);
        this.run(controller);
        return controller.allTrue();
    }

    public boolean anyTrue(Constraint constraint) {
        return this.findFirst(constraint, null) != null;
    }

    public ElementGenerator findAll(final Constraint constraint) {
        return new AbstractElementGenerator(this){

            public void run(Closure closure) {
                this.getWrappedTemplate().run(new IfBlock(constraint, closure));
            }
        };
    }

    public Object findFirst(Constraint constraint) {
        return this.findFirst(constraint, null);
    }

    public Object findFirst(Constraint constraint, Object defaultIfNoneFound) {
        ObjectFinder finder = new ObjectFinder(this, constraint);
        this.run(finder);
        return finder.foundObject() ? finder.getFoundObject() : defaultIfNoneFound;
    }

    public boolean isStopped() {
        return this.status == ProcessStatus.STOPPED;
    }

    public boolean isFinished() {
        return this.status == ProcessStatus.COMPLETED;
    }

    public boolean isRunning() {
        return this.status == ProcessStatus.RUNNING;
    }

    public void stop() throws IllegalStateException {
        if (this.wrappedGenerator != null) {
            this.wrappedGenerator.stop();
        }
        this.status = ProcessStatus.STOPPED;
    }

    public void runUntil(Closure templateCallback, Constraint constraint) {
        this.run(new UntilTrueController(this, templateCallback, constraint));
    }

    protected void reset() {
        if (this.status == ProcessStatus.STOPPED || this.status == ProcessStatus.COMPLETED) {
            if (this.runOnce) {
                throw new UnsupportedOperationException("This process template can only safely execute once; instantiate a new instance per request");
            }
            this.status = ProcessStatus.RESET;
        }
    }

    protected void setRunning() {
        this.status = ProcessStatus.RUNNING;
    }

    protected void setCompleted() {
        this.status = ProcessStatus.COMPLETED;
    }

    public abstract void run(Closure var1);

    private static class ObjectFinder
    extends Block {
        private static final long serialVersionUID = 1L;
        private ElementGenerator generator;
        private Constraint constraint;
        private Object foundObject;

        public ObjectFinder(ElementGenerator generator, Constraint constraint) {
            this.generator = generator;
            this.constraint = constraint;
        }

        protected void handle(Object o) {
            if (this.constraint.test(o)) {
                this.foundObject = o;
                this.generator.stop();
            }
        }

        public boolean foundObject() {
            return this.foundObject != null;
        }

        public Object getFoundObject() {
            return this.foundObject;
        }
    }

    private static class UntilTrueController
    extends Block {
        private static final long serialVersionUID = 1L;
        private ElementGenerator template;
        private Closure templateCallback;
        private Constraint constraint;

        public UntilTrueController(ElementGenerator template, Closure templateCallback, Constraint constraint) {
            this.template = template;
            this.templateCallback = templateCallback;
            this.constraint = constraint;
        }

        protected void handle(Object o) {
            if (this.constraint.test(o)) {
                this.template.stop();
            } else {
                this.templateCallback.call(o);
            }
        }
    }

    private static class WhileTrueController
    extends Block {
        private static final long serialVersionUID = 1L;
        private ElementGenerator template;
        private Constraint constraint;
        private boolean allTrue = true;

        public WhileTrueController(ElementGenerator template, Constraint constraint) {
            this.template = template;
            this.constraint = constraint;
        }

        protected void handle(Object o) {
            if (!this.constraint.test(o)) {
                this.allTrue = false;
                this.template.stop();
            }
        }

        public boolean allTrue() {
            return this.allTrue;
        }
    }
}

