/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.closure.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.rules.closure.Closure;
import org.springframework.rules.closure.ElementGenerator;
import org.springframework.rules.closure.support.Block;
import org.springframework.rules.closure.support.IteratorTemplate;
import org.springframework.rules.constraint.Constraint;

public class Algorithms {
    private static Algorithms INSTANCE = new Algorithms();

    public static void load(Algorithms instance) {
        INSTANCE = instance;
    }

    public static Algorithms instance() {
        return INSTANCE;
    }

    public boolean anyTrue(Collection collection, Constraint constraint) {
        return this.anyTrue(collection.iterator(), constraint);
    }

    public boolean anyTrue(Iterator it, Constraint constraint) {
        return new IteratorTemplate(it).anyTrue(constraint);
    }

    public boolean allTrue(Collection collection, Constraint constraint) {
        return this.allTrue(collection.iterator(), constraint);
    }

    public boolean allTrue(Iterator it, Constraint constraint) {
        return new IteratorTemplate(it).allTrue(constraint);
    }

    public Object findFirst(Collection collection, Constraint constraint) {
        return this.findFirst(collection.iterator(), constraint);
    }

    public Object findFirst(Iterator it, Constraint constraint) {
        return new IteratorTemplate(it).findFirst(constraint);
    }

    public Collection findAll(Collection collection, Constraint constraint) {
        return this.findAll(collection.iterator(), constraint);
    }

    public Collection findAll(Iterator it, Constraint constraint) {
        ElementGenerator finder = new IteratorTemplate(it).findAll(constraint);
        final ArrayList results = new ArrayList();
        finder.run(new Block(){

            protected void handle(Object element) {
                results.add(element);
            }
        });
        return results;
    }

    public void forEach(Collection collection, Closure closure) {
        this.forEach(collection.iterator(), closure);
    }

    public void forEach(Iterator it, Closure closure) {
        new IteratorTemplate(it).run(closure);
    }
}

