/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import org.springframework.rules.closure.BinaryConstraint;
import org.springframework.rules.constraint.Constraint;

public class ParameterizedBinaryConstraint
implements Constraint {
    private BinaryConstraint constraint;
    private Object parameter;

    public ParameterizedBinaryConstraint(BinaryConstraint constraint, Object parameter) {
        this.constraint = constraint;
        this.parameter = parameter;
    }

    public ParameterizedBinaryConstraint(BinaryConstraint constraint, short number) {
        this(constraint, new Short(number));
    }

    public ParameterizedBinaryConstraint(BinaryConstraint constraint, byte b) {
        this(constraint, new Byte(b));
    }

    public ParameterizedBinaryConstraint(BinaryConstraint constraint, int number) {
        this(constraint, new Integer(number));
    }

    public ParameterizedBinaryConstraint(BinaryConstraint constraint, float number) {
        this(constraint, new Float(number));
    }

    public ParameterizedBinaryConstraint(BinaryConstraint constraint, double number) {
        this(constraint, new Double(number));
    }

    public ParameterizedBinaryConstraint(BinaryConstraint constraint, boolean bool) {
        this(constraint, bool ? Boolean.TRUE : Boolean.FALSE);
    }

    public Object getParameter() {
        return this.parameter;
    }

    public BinaryConstraint getConstraint() {
        return this.constraint;
    }

    public boolean test(Object value) {
        return this.constraint.test(value, this.parameter);
    }

    public String toString() {
        return this.constraint.toString() + " " + this.getParameter();
    }
}

