/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import org.springframework.rules.closure.BinaryConstraint;
import org.springframework.rules.constraint.EqualTo;
import org.springframework.rules.constraint.GreaterThan;
import org.springframework.rules.constraint.GreaterThanEqualTo;
import org.springframework.rules.constraint.LessThan;
import org.springframework.rules.constraint.LessThanEqualTo;
import org.springframework.rules.constraint.Operator;

public abstract class RelationalOperator
extends Operator {
    public static final RelationalOperator EQUAL_TO = new RelationalOperator("eq", "="){

        public BinaryConstraint getConstraint() {
            return EqualTo.instance();
        }
    };
    public static final RelationalOperator LESS_THAN = new RelationalOperator("lt", "<"){

        public Operator negation() {
            return GREATER_THAN;
        }

        public BinaryConstraint getConstraint() {
            return LessThan.instance();
        }
    };
    public static final RelationalOperator LESS_THAN_EQUAL_TO = new RelationalOperator("lte", "<="){

        public Operator negation() {
            return GREATER_THAN_EQUAL_TO;
        }

        public BinaryConstraint getConstraint() {
            return LessThanEqualTo.instance();
        }
    };
    public static final RelationalOperator GREATER_THAN = new RelationalOperator("gt", ">"){

        public Operator negation() {
            return LESS_THAN;
        }

        public BinaryConstraint getConstraint() {
            return GreaterThan.instance();
        }
    };
    public static final RelationalOperator GREATER_THAN_EQUAL_TO = new RelationalOperator("gte", ">="){

        public Operator negation() {
            return LESS_THAN_EQUAL_TO;
        }

        public BinaryConstraint getConstraint() {
            return GreaterThanEqualTo.instance();
        }
    };

    private RelationalOperator(String code, String symbol) {
        super(code, symbol);
    }

    public abstract BinaryConstraint getConstraint();
}

