/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.rules.closure.BinaryConstraint;
import org.springframework.rules.constraint.property.AbstractPropertyConstraint;
import org.springframework.util.Assert;

public class PropertiesConstraint
extends AbstractPropertyConstraint {
    private String otherPropertyName;
    private BinaryConstraint beanPropertyExpression;

    public PropertiesConstraint(String propertyName, BinaryConstraint beanPropertyExpression, String otherPropertyName) {
        super(propertyName);
        Assert.notNull((Object)otherPropertyName, (String)"otherPropertyName is required");
        Assert.notNull((Object)beanPropertyExpression, (String)"beanPropertyExpression is required");
        this.otherPropertyName = otherPropertyName;
        this.beanPropertyExpression = beanPropertyExpression;
    }

    public boolean isCompoundRule() {
        return true;
    }

    public boolean isDependentOn(String propertyName) {
        return this.getPropertyName().equals(propertyName) || this.getOtherPropertyName().equals(propertyName);
    }

    public String getOtherPropertyName() {
        return this.otherPropertyName;
    }

    public BinaryConstraint getConstraint() {
        return this.beanPropertyExpression;
    }

    protected boolean test(PropertyAccessStrategy domainObjectAccessStrategy) {
        return this.beanPropertyExpression.test(domainObjectAccessStrategy.getPropertyValue(this.getPropertyName()), domainObjectAccessStrategy.getPropertyValue(this.getOtherPropertyName()));
    }

    public String toString() {
        return super.toString() + " " + this.beanPropertyExpression.toString() + " " + this.otherPropertyName;
    }
}

