/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.reporting;

import org.springframework.rules.reporting.BeanPropertyNameRenderer;
import org.springframework.util.Assert;

public class DefaultBeanPropertyNameRenderer
implements BeanPropertyNameRenderer {
    public String renderQualifiedName(String qualifiedName) {
        Assert.notNull((Object)qualifiedName, (String)"No qualified name specified");
        StringBuffer sb = new StringBuffer(qualifiedName.length() + 5);
        char[] chars = qualifiedName.toCharArray();
        sb.append(Character.toUpperCase(chars[0]));
        boolean foundDot = false;
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isLetter(c)) {
                if (Character.isLowerCase(c)) {
                    if (foundDot) {
                        sb.append(Character.toUpperCase(c));
                        foundDot = false;
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c != '.') continue;
            sb.append(c);
            foundDot = true;
        }
        return sb.toString();
    }

    public String renderShortName(String shortName) {
        Assert.notNull((Object)shortName, (String)"No short name specified");
        StringBuffer sb = new StringBuffer(shortName.length() + 5);
        char[] chars = shortName.toCharArray();
        sb.append(Character.toUpperCase(chars[0]));
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isUpperCase(c)) {
                sb.append(' ');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

