/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.reporting;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ReflectiveVisitorHelper;
import org.springframework.core.style.ToStringCreator;
import org.springframework.rules.closure.Closure;
import org.springframework.rules.constraint.And;
import org.springframework.rules.constraint.ClosureResultConstraint;
import org.springframework.rules.constraint.Constraint;
import org.springframework.rules.constraint.Not;
import org.springframework.rules.constraint.Or;
import org.springframework.rules.reporting.ValidationResults;
import org.springframework.rules.reporting.ValidationResultsBuilder;
import org.springframework.rules.reporting.ValueValidationResults;

public class ValidationResultsCollector {
    protected static final Log logger = LogFactory.getLog(ValidationResultsCollector.class);
    protected ReflectiveVisitorHelper visitorSupport = new ReflectiveVisitorHelper();
    private ValidationResultsBuilder resultsBuilder;
    private ValidationResults results;
    private boolean collectAllErrors;
    private Object argument;

    public ValidationResults collect(final Object argument, Constraint constraint) {
        this.resultsBuilder = new ValidationResultsBuilder(){

            public void constraintSatisfied() {
            }

            public void constraintViolated(Constraint constraint) {
                ValidationResultsCollector.this.results = new ValueValidationResults(argument, constraint);
            }
        };
        if (this.results == null) {
            this.results = new ValueValidationResults(argument);
        }
        this.argument = argument;
        this.visitorSupport.invokeVisit((Object)this, (Object)constraint);
        return this.results;
    }

    public void setCollectAllErrors(boolean collectAllErrors) {
        this.collectAllErrors = collectAllErrors;
    }

    protected ValidationResultsBuilder getResultsBuilder() {
        return this.resultsBuilder;
    }

    protected void setResultsBuilder(ValidationResultsBuilder resultsBuilder) {
        this.resultsBuilder = resultsBuilder;
    }

    protected void setArgument(Object argument) {
        this.argument = argument;
    }

    boolean visit(And and) {
        this.resultsBuilder.pushAnd();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting [and]...");
        }
        boolean result = true;
        Iterator it = and.iterator();
        while (it.hasNext()) {
            boolean test = (Boolean)this.visitorSupport.invokeVisit((Object)this, it.next());
            if (test) continue;
            if (!this.collectAllErrors) {
                this.resultsBuilder.pop(false);
                return false;
            }
            if (!result) continue;
            result = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Finished [and]...");
        }
        this.resultsBuilder.pop(result);
        return result;
    }

    boolean visit(Or or) {
        this.resultsBuilder.pushOr();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting [or]...");
        }
        Iterator it = or.iterator();
        while (it.hasNext()) {
            boolean result = (Boolean)this.visitorSupport.invokeVisit((Object)this, it.next());
            if (!result) continue;
            this.resultsBuilder.pop(result);
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Finished [or]...");
        }
        this.resultsBuilder.pop(false);
        return false;
    }

    Boolean visit(Not not) {
        this.resultsBuilder.pushNot();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting [not]...");
        }
        Boolean result = (Boolean)this.visitorSupport.invokeVisit((Object)this, (Object)not.getConstraint());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Finished [not]...");
        }
        this.resultsBuilder.pop(result);
        return result;
    }

    Boolean visit(ClosureResultConstraint ofConstraint) {
        Closure f = ofConstraint.getFunction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking function with argument " + this.argument));
        }
        this.setArgument(f.call(this.argument));
        return (Boolean)this.visitorSupport.invokeVisit((Object)this, (Object)ofConstraint.getPredicate());
    }

    boolean visit(Constraint constraint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Testing constraint [" + constraint + "] with argument '" + this.argument + "']"));
        }
        boolean result = constraint.test(this.argument);
        if (!(result = this.applyAnyNegation(result))) {
            this.resultsBuilder.push(constraint);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Constraint [" + constraint + "] " + (result ? "passed" : "failed")));
        }
        return result;
    }

    protected boolean applyAnyNegation(boolean result) {
        boolean negated = this.resultsBuilder.negated();
        if (logger.isDebugEnabled()) {
            if (negated) {
                logger.debug((Object)"[negate result]");
            } else {
                logger.debug((Object)"[no negation]");
            }
        }
        return negated ? !result : result;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("collectAllErrors", this.collectAllErrors).append("validationResultsBuilder", (Object)this.resultsBuilder).toString();
    }
}

