@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  modeller startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and MODELLER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=C:/Progra~2/Java/jre7/bin/java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windowz variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\modeller-1.2.0.jar;%APP_HOME%\lib\modeller-core-1.2.0.jar;%APP_HOME%\lib\modeller-business-1.2.0.jar;%APP_HOME%\lib\modeller-fedora-1.2.0.jar;%APP_HOME%\lib\modeller-marshaller-1.2.0.jar;%APP_HOME%\lib\modeller-hocr-1.2.0.jar;%APP_HOME%\lib\vldocking-2.1.4.jar;%APP_HOME%\lib\nachocalendar-0.23.jar;%APP_HOME%\lib\spring-richclient-resources-1.1.0.jar;%APP_HOME%\lib\spring-richclient-docking-1.0.0.jar;%APP_HOME%\lib\spring-richclient-sandbox-1.0.0.jar;%APP_HOME%\lib\spring-richclient-core-1.1.0.jar;%APP_HOME%\lib\spring-richclient-jdk6-1.1.0.jar;%APP_HOME%\lib\spring-richclient-vldocking-1.1.0.jar;%APP_HOME%\lib\forms-1.2.1.jar;%APP_HOME%\lib\swingx-1.6.1.jar;%APP_HOME%\lib\groovy-all-2.4.7.jar;%APP_HOME%\lib\spring-boot-starter-logging-1.4.0.RELEASE.jar;%APP_HOME%\lib\commons-lang-2.6.jar;%APP_HOME%\lib\looks-2.0.4.jar;%APP_HOME%\lib\bagit-4.12.1.jar;%APP_HOME%\lib\json-20151123.jar;%APP_HOME%\lib\fcrepo-java-client-0.2.0.jar;%APP_HOME%\lib\compiler-0.9.3.jar;%APP_HOME%\lib\commons-io-2.5.jar;%APP_HOME%\lib\jena-core-3.1.0.jar;%APP_HOME%\lib\jena-arq-3.1.0.jar;%APP_HOME%\lib\imageio-tiff-3.2.1.jar;%APP_HOME%\lib\jersey-common-2.23.2.jar;%APP_HOME%\lib\xmlprojector-1.4.8.jar;%APP_HOME%\lib\spring-richclient-support-1.0.0.jar;%APP_HOME%\lib\filters-2.0.235.jar;%APP_HOME%\lib\swing-worker-1.1.jar;%APP_HOME%\lib\commons-compress-1.8.1.jar;%APP_HOME%\lib\commons-logging-api-1.1.jar;%APP_HOME%\lib\commons-codec-1.9.jar;%APP_HOME%\lib\httpmime-4.3.2.jar;%APP_HOME%\lib\jsap-2.1.jar;%APP_HOME%\lib\dom4j-1.6.1.jar;%APP_HOME%\lib\commons-net-3.3.jar;%APP_HOME%\lib\commons-exec-1.2.jar;%APP_HOME%\lib\jaxen-1.1.4.jar;%APP_HOME%\lib\classworlds-1.1.jar;%APP_HOME%\lib\log4j-1.2.17.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\commons-lang3-3.3.2.jar;%APP_HOME%\lib\jena-iri-3.1.0.jar;%APP_HOME%\lib\xercesImpl-2.11.0.jar;%APP_HOME%\lib\commons-cli-1.3.jar;%APP_HOME%\lib\jena-base-3.1.0.jar;%APP_HOME%\lib\jena-shaded-guava-3.1.0.jar;%APP_HOME%\lib\jsonld-java-0.7.0.jar;%APP_HOME%\lib\httpclient-cache-4.2.6.jar;%APP_HOME%\lib\libthrift-0.9.2.jar;%APP_HOME%\lib\commons-csv-1.0.jar;%APP_HOME%\lib\imageio-core-3.2.1.jar;%APP_HOME%\lib\imageio-metadata-3.2.1.jar;%APP_HOME%\lib\common-lang-3.2.1.jar;%APP_HOME%\lib\common-io-3.2.1.jar;%APP_HOME%\lib\common-image-3.2.1.jar;%APP_HOME%\lib\javax.annotation-api-1.2.jar;%APP_HOME%\lib\jersey-guava-2.23.2.jar;%APP_HOME%\lib\hk2-api-2.5.0-b05.jar;%APP_HOME%\lib\javax.inject-2.5.0-b05.jar;%APP_HOME%\lib\hk2-locator-2.5.0-b05.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.1.jar;%APP_HOME%\lib\spring-richclient-binding-1.0.0.jar;%APP_HOME%\lib\spring-richclient-form-1.0.0.jar;%APP_HOME%\lib\collection-0.6.jar;%APP_HOME%\lib\jackson-core-2.3.3.jar;%APP_HOME%\lib\jackson-databind-2.3.3.jar;%APP_HOME%\lib\hk2-utils-2.5.0-b05.jar;%APP_HOME%\lib\aopalliance-repackaged-2.5.0-b05.jar;%APP_HOME%\lib\javassist-3.20.0-GA.jar;%APP_HOME%\lib\jackson-annotations-2.3.0.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\ognl-2.6.9.jar;%APP_HOME%\lib\logback-classic-1.1.7.jar;%APP_HOME%\lib\jul-to-slf4j-1.7.21.jar;%APP_HOME%\lib\log4j-over-slf4j-1.7.21.jar;%APP_HOME%\lib\logback-core-1.1.7.jar;%APP_HOME%\lib\commons-logging-1.1.3.jar;%APP_HOME%\lib\httpclient-4.3.6.jar;%APP_HOME%\lib\httpcore-4.3.3.jar;%APP_HOME%\lib\slf4j-api-1.7.21.jar;%APP_HOME%\lib\javax.ws.rs-api-2.0.1.jar;%APP_HOME%\lib\xml-apis-1.4.01.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.21.jar;%APP_HOME%\lib\spring-beans-2.5.5.jar;%APP_HOME%\lib\spring-context-2.5.5.jar;%APP_HOME%\lib\spring-core-2.5.5.jar;%APP_HOME%\lib\spring-web-2.5.5.jar;%APP_HOME%\lib\spring-binding-1.0.5.jar;%APP_HOME%\lib\commons-collections-3.2.1.jar

@rem Execute modeller
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% -Dapp.home=%APP_HOME% %MODELLER_OPTS%  -classpath "%CLASSPATH%" cool.pandora.modeller.ModellerApplication --spring.config.location=file:%APP_HOME%/config/application.properties %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
pause

rem Set variable MODELLER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%MODELLER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
