/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern.duplex;

import java.io.PrintStream;
import java.util.List;
import org.xmlbeam.util.intern.DOMHelper;
import org.xmlbeam.util.intern.duplex.INodeEvaluationVisitor;
import org.xmlbeam.util.intern.duplex.Node;
import org.xmlbeam.util.intern.duplex.PostParseException;
import org.xmlbeam.util.intern.duplex.Token;
import org.xmlbeam.util.intern.duplex.XParser;
import org.xmlbeam.util.intern.duplex.XParserTreeConstants;
import org.xmlbeam.util.intern.duplex.XParserVisitor;

class SimpleNode
implements Node {
    private Node parent;
    private SimpleNode[] children;
    final int id;
    private final XParser parser;
    public int beginLine;
    public int beginColumn;
    public int endLine;
    public int endColumn;
    private String m_value;
    private Token firstToken;
    private Token lastToken;

    public SimpleNode(XParser p, int i) {
        this.id = i;
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
        this.beginLine = this.parser.token.beginLine;
        this.beginColumn = this.parser.token.beginColumn;
    }

    @Override
    public void jjtClose() {
        this.endLine = this.parser.token.endLine;
        this.endColumn = this.parser.token.endColumn;
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.id == 87 && ((SimpleNode)n).id == 88) {
            this.m_value = ((SimpleNode)n).m_value;
            if (this.m_value.indexOf(58) >= 0) {
                throw new PostParseException("Parse Error: NCName can not contain ':'!");
            }
            return;
        }
        if (this.id == 88 && ((SimpleNode)n).id == 89) {
            this.m_value = ((SimpleNode)n).m_value;
            return;
        }
        if (this.children == null) {
            this.children = new SimpleNode[i + 1];
        } else if (i >= this.children.length) {
            SimpleNode[] c = new SimpleNode[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = (SimpleNode)n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(XParserVisitor visitor, org.w3c.dom.Node data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(XParserVisitor visitor, org.w3c.dom.Node data) {
        org.w3c.dom.Node result = data;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object newResult = this.children[i].jjtAccept(visitor, result);
                if (Boolean.FALSE.equals(newResult)) {
                    return Boolean.FALSE;
                }
                if (Boolean.TRUE.equals(newResult)) {
                    if (i + 1 != this.children.length) continue;
                    return Boolean.TRUE;
                }
                if (newResult instanceof List) {
                    Object object = newResult = ((List)newResult).isEmpty() ? null : (Object)((List)newResult).get(0);
                }
                if (newResult instanceof Number) {
                    return newResult;
                }
                result = (org.w3c.dom.Node)newResult;
            }
        }
        return DOMHelper.asList(result);
    }

    public Object firstChildAccept(XParserVisitor visitor, org.w3c.dom.Node data) {
        assert (this.children.length > 0) : "No child found for node " + this;
        return this.children[0].jjtAccept(visitor, data);
    }

    public Object secondChildAccept(XParserVisitor visitor, org.w3c.dom.Node data) {
        assert (this.children.length > 1) : "No second child found for node " + this;
        return this.children[1].jjtAccept(visitor, data);
    }

    public String toString() {
        return XParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        this.dump(prefix, System.out);
    }

    public void dump(String prefix, PrintStream ps) {
        ps.print(this.toString(prefix));
        this.printValue(ps);
        ps.print(" [" + this.firstToken.beginLine + ":" + this.firstToken.beginColumn + "-" + this.lastToken.endLine + ":" + this.lastToken.endColumn + "]");
        ps.println();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = this.children[i];
                if (n == null) continue;
                n.dump(prefix + "   ", ps);
            }
        }
    }

    public void processToken(Token t) {
        this.m_value = t.image;
    }

    public void processValue(String val) {
        this.m_value = val;
    }

    public void printValue(PrintStream ps) {
        if (null != this.m_value) {
            ps.print(" \"" + this.m_value + "\"");
        }
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String m_value) {
        this.m_value = m_value;
    }

    public int getID() {
        return this.id;
    }

    public SimpleNode getFirstChildWithId(int id) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i].getID() != id) continue;
                return this.children[i];
            }
        }
        return null;
    }

    public <T> T firstChildAccept(INodeEvaluationVisitor<T> visitor, org.w3c.dom.Node data) {
        if (this.children.length < 1) {
            throw new IllegalArgumentException("Node " + this + " is supposed to have children");
        }
        return visitor.visit(this.children[0], data);
    }

    public <T> T lastChildAccept(INodeEvaluationVisitor<T> visitor, org.w3c.dom.Node data) {
        if (this.children.length < 1) {
            throw new IllegalArgumentException("Node " + this + " is supposed to have children");
        }
        return visitor.visit(this.children[this.children.length - 1], data);
    }

    public void eachDirectChild(INodeEvaluationVisitor.VisitorClosure visitorClosure, org.w3c.dom.Node data) {
        if (this.children == null) {
            return;
        }
        for (SimpleNode child : this.children) {
            visitorClosure.apply(child, data);
        }
    }

    public void eachChild(INodeEvaluationVisitor.VisitorClosure visitorClosure, org.w3c.dom.Node data) {
        if (this.children == null) {
            return;
        }
        for (SimpleNode child : this.children) {
            visitorClosure.apply(child, data);
            child.eachChild(visitorClosure, data);
        }
    }

    public List<org.w3c.dom.Node> childrenAcceptWithFilter(XParserVisitor visitor, org.w3c.dom.Node data, StepListFilter stepListFilter) {
        if (stepListFilter == null) {
            return (List)this.childrenAccept(visitor, data);
        }
        List<SimpleNode> filteredChildren = stepListFilter.filter(this.children);
        org.w3c.dom.Node result = data;
        for (Node node : filteredChildren) {
            Object newResult = node.jjtAccept(visitor, result);
            if (newResult instanceof List) {
                newResult = ((List)newResult).isEmpty() ? null : ((List)newResult).get(0);
            }
            result = (org.w3c.dom.Node)newResult;
        }
        return DOMHelper.asList(result);
    }

    void jjtSetFirstToken(Token token) {
        this.firstToken = token;
    }

    void jjtSetLastToken(Token token) {
        this.lastToken = token;
    }

    public int getStartColumn() {
        return this.firstToken.beginColumn - 1;
    }

    public int getEndColumn() {
        return this.lastToken.endColumn - 1;
    }

    public static interface StepListFilter {
        public List<SimpleNode> filter(SimpleNode[] var1);
    }
}

