/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import cool.pandora.modeller.ImageFileDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class XmlFileWriter
extends ByteArrayOutputStream {
    public static XMLWriterBuilder write() {
        return new XMLWriterBuilder();
    }

    protected XmlFileWriter() {
    }

    private static ByteArrayOutputStream marshal(ImageFileDescriptor fileDescriptor) throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ImageFileDescriptor.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal((Object)fileDescriptor, (OutputStream)out);
        return out;
    }

    public static class XMLWriterBuilder {
        private String collectionId;
        private String objektId;
        private String resourceId;

        public XMLWriterBuilder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public XMLWriterBuilder objektId(String objektId) {
            this.objektId = objektId;
            return this;
        }

        public XMLWriterBuilder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public ByteArrayOutputStream build() throws JAXBException {
            String descriptor = this.collectionId + "." + this.objektId + "." + this.resourceId;
            ImageFileDescriptor fileDescriptor = new ImageFileDescriptor();
            fileDescriptor.setId(descriptor);
            return XmlFileWriter.marshal(fileDescriptor);
        }
    }
}

