/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;

public abstract class AbstractCredentialsAuthenticator
implements HttpAuthenticator {
    @Override
    public void apply(AbstractHttpClient client, HttpContext context, URI target) {
        if (!this.hasUserName(target)) {
            return;
        }
        HttpHost host = new HttpHost(target.getHost(), target.getPort());
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(host), this.createCredentials(target));
        client.setCredentialsProvider((CredentialsProvider)provider);
    }

    @Override
    public void invalidate() {
    }

    protected Credentials createCredentials(URI target) {
        String user = this.getUserName(target);
        char[] password = this.getPassword(target);
        return password != null ? new UsernamePasswordCredentials(user, new String(password)) : new UsernamePasswordCredentials(user, "");
    }

    protected abstract boolean hasUserName(URI var1);

    protected abstract String getUserName(URI var1);

    protected abstract boolean hasPassword(URI var1);

    protected abstract char[] getPassword(URI var1);
}

