/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Objects;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.sparql.core.Quad;

public class ParserProfileBase
implements ParserProfile {
    protected ErrorHandler errorHandler;
    protected Prologue prologue;
    protected boolean strictMode = SysRIOT.isStrictMode();
    protected FactoryRDF factory;

    public ParserProfileBase(Prologue prologue, ErrorHandler errorHandler) {
        this(prologue, errorHandler, RiotLib.factoryRDF());
    }

    public ParserProfileBase(Prologue prologue, ErrorHandler errorHandler, FactoryRDF factory) {
        Objects.requireNonNull(prologue);
        Objects.requireNonNull(errorHandler);
        Objects.requireNonNull(factory);
        this.prologue = prologue;
        this.errorHandler = errorHandler;
        this.factory = factory;
    }

    @Override
    public ErrorHandler getHandler() {
        return this.errorHandler;
    }

    @Override
    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public Prologue getPrologue() {
        return this.prologue;
    }

    @Override
    public void setPrologue(Prologue p) {
        this.prologue = p;
    }

    @Override
    public FactoryRDF getFactoryRDF() {
        return this.factory;
    }

    @Override
    public void setFactoryRDF(FactoryRDF factory) {
        this.factory = factory;
    }

    @Override
    public String resolveIRI(String uriStr, long line, long col) {
        return this.prologue.getResolver().resolveToString(uriStr);
    }

    @Override
    public IRI makeIRI(String uriStr, long line, long col) {
        return this.prologue.getResolver().resolve(uriStr);
    }

    @Override
    public Quad createQuad(Node g, Node s, Node p, Node o, long line, long col) {
        return this.factory.createQuad(g, s, p, o);
    }

    @Override
    public Triple createTriple(Node s, Node p, Node o, long line, long col) {
        return this.factory.createTriple(s, p, o);
    }

    @Override
    public Node createURI(String uriStr, long line, long col) {
        return this.factory.createURI(uriStr);
    }

    @Override
    public Node createBlankNode(Node scope, String label, long line, long col) {
        return this.factory.createBlankNode(label);
    }

    @Override
    public Node createBlankNode(Node scope, long line, long col) {
        return this.factory.createBlankNode();
    }

    @Override
    public Node createTypedLiteral(String lexical, RDFDatatype dt, long line, long col) {
        return this.factory.createTypedLiteral(lexical, dt);
    }

    @Override
    public Node createLangLiteral(String lexical, String langTag, long line, long col) {
        return this.factory.createLangLiteral(lexical, langTag);
    }

    @Override
    public Node createStringLiteral(String lexical, long line, long col) {
        return this.factory.createStringLiteral(lexical);
    }

    @Override
    public Node createNodeFromToken(Node scope, Token token, long line, long col) {
        return null;
    }

    @Override
    public Node create(Node currentGraph, Token token) {
        return ParserProfileBase.create(this, currentGraph, token);
    }

    private static Node create(ParserProfile pp, Node currentGraph, Token token) {
        long line = token.getLine();
        long col = token.getColumn();
        String str2 = token.getImage();
        switch (token.getType()) {
            case BNODE: {
                return pp.createBlankNode(currentGraph, str2, line, col);
            }
            case IRI: {
                return pp.createURI(str2, line, col);
            }
            case PREFIXED_NAME: {
                String prefix = str2;
                String suffix = token.getImage2();
                String expansion = ParserProfileBase.expandPrefixedName(pp, prefix, suffix, token);
                return pp.createURI(expansion, line, col);
            }
            case DECIMAL: {
                return pp.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDdecimal, line, col);
            }
            case DOUBLE: {
                return pp.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDdouble, line, col);
            }
            case INTEGER: {
                return pp.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDinteger, line, col);
            }
            case LITERAL_DT: {
                String uriStr;
                Token tokenDT = token.getSubToken2();
                switch (tokenDT.getType()) {
                    case IRI: {
                        uriStr = tokenDT.getImage();
                        break;
                    }
                    case PREFIXED_NAME: {
                        String prefix = tokenDT.getImage();
                        String suffix = tokenDT.getImage2();
                        uriStr = ParserProfileBase.expandPrefixedName(pp, prefix, suffix, tokenDT);
                        break;
                    }
                    default: {
                        throw new RiotException("Expected IRI for datatype: " + token);
                    }
                }
                uriStr = pp.resolveIRI(uriStr, tokenDT.getLine(), tokenDT.getColumn());
                RDFDatatype dt = NodeFactory.getType((String)uriStr);
                return pp.createTypedLiteral(str2, dt, line, col);
            }
            case LITERAL_LANG: {
                return pp.createLangLiteral(str2, token.getImage2(), line, col);
            }
            case STRING: 
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: {
                return pp.createStringLiteral(str2, line, col);
            }
        }
        Node x = pp.createNodeFromToken(currentGraph, token, line, col);
        if (x != null) {
            return x;
        }
        pp.getHandler().fatal("Not a valid token for an RDF term: " + token, line, col);
        return null;
    }

    private static String expandPrefixedName(ParserProfile pp, String prefix, String localPart, Token token) {
        String expansion = pp.getPrologue().getPrefixMap().expand(prefix, localPart);
        if (expansion == null) {
            if (ARQ.isTrue(ARQ.fixupUndefinedPrefixes)) {
                return RiotLib.fixupPrefixIRI(prefix, localPart);
            }
            pp.getHandler().fatal("Undefined prefix: " + prefix, token.getLine(), token.getColumn());
        }
        return expansion;
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Override
    public void setStrictMode(boolean mode) {
        this.strictMode = mode;
    }
}

