/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.ServiceAuthenticator;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.web.HttpCaptureResponse;
import org.apache.jena.riot.web.HttpResponseHandler;
import org.apache.jena.riot.web.HttpResponseLib;
import org.apache.jena.sparql.engine.http.Params;
import org.apache.jena.web.HttpSC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOp {
    private static Logger log = LoggerFactory.getLogger(HttpOp.class);
    private static AtomicLong counter = new AtomicLong(0L);
    private static HttpClient defaultHttpClient = null;
    private static boolean useDefaultClientWithAuthentication = false;
    private static HttpAuthenticator defaultAuthenticator = new ServiceAuthenticator();
    public static final String ARQ_USER_AGENT;
    private static String userAgent;
    private static HttpResponseHandler nullHandler;

    public static HttpAuthenticator getDefaultAuthenticator() {
        return defaultAuthenticator;
    }

    public static void setDefaultAuthenticator(HttpAuthenticator authenticator) {
        defaultAuthenticator = authenticator;
    }

    public static HttpClient getDefaultHttpClient() {
        return defaultHttpClient;
    }

    public static void setDefaultHttpClient(HttpClient httpClient) {
        defaultHttpClient = httpClient;
    }

    public static boolean getUseDefaultClientWithAuthentication() {
        return useDefaultClientWithAuthentication;
    }

    public static void setUseDefaultClientWithAuthentication(boolean useWithAuth) {
        useDefaultClientWithAuthentication = useWithAuth;
    }

    public static HttpClient createCachingHttpClient() {
        return new SystemDefaultHttpClient(){

            protected ClientConnectionManager createClientConnectionManager() {
                PoolingClientConnectionManager connmgr = new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
                String s = System.getProperty("http.maxConnections", "5");
                int max2 = Integer.parseInt(s);
                connmgr.setDefaultMaxPerRoute(max2);
                connmgr.setMaxTotal(2 * max2);
                return connmgr;
            }
        };
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static void setUserAgent(String userAgent) {
        HttpOp.userAgent = userAgent;
    }

    public static void execHttpGet(String url, String acceptHeader, HttpResponseHandler handler) {
        HttpOp.execHttpGet(url, acceptHeader, handler, null, null, null);
    }

    public static void execHttpGet(String url, String acceptHeader, HttpResponseHandler handler, HttpAuthenticator authenticator) {
        HttpOp.execHttpGet(url, acceptHeader, handler, null, null, authenticator);
    }

    public static void execHttpGet(String url, String acceptHeader, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        String requestURI = HttpOp.determineRequestURI(url);
        HttpGet httpget = new HttpGet(requestURI);
        HttpOp.exec(url, (HttpUriRequest)httpget, acceptHeader, handler, httpClient, httpContext, authenticator);
    }

    public static TypedInputStream execHttpGet(String url) {
        CaptureInput handler = new CaptureInput();
        HttpOp.execHttpGet(url, null, handler, null, null, null);
        return (TypedInputStream)handler.get();
    }

    public static TypedInputStream execHttpGet(String url, String acceptHeader) {
        CaptureInput handler = new CaptureInput();
        HttpOp.execHttpGet(url, acceptHeader, handler, null, null, null);
        return (TypedInputStream)handler.get();
    }

    public static TypedInputStream execHttpGet(String url, String acceptHeader, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        CaptureInput handler = new CaptureInput();
        try {
            HttpOp.execHttpGet(url, acceptHeader, handler, httpClient, httpContext, authenticator);
        }
        catch (HttpException ex) {
            if (ex.getResponseCode() == 404) {
                return null;
            }
            throw ex;
        }
        return (TypedInputStream)handler.get();
    }

    public static String execHttpGetString(String url) {
        return HttpOp.execHttpGetString(url, null);
    }

    public static String execHttpGetString(String url, String acceptHeader) {
        CaptureString handler = new CaptureString();
        try {
            HttpOp.execHttpGet(url, acceptHeader, handler);
        }
        catch (HttpException ex) {
            if (ex.getResponseCode() == 404) {
                return null;
            }
            throw ex;
        }
        return handler.get();
    }

    public static void execHttpPost(String url, String contentType, String content) {
        HttpOp.execHttpPost(url, contentType, content, null, nullHandler, null, null, defaultAuthenticator);
    }

    public static TypedInputStream execHttpPostStream(String url, String contentType, String content, String acceptType) {
        return HttpOp.execHttpPostStream(url, contentType, content, acceptType, null, null, null);
    }

    public static void execHttpPost(String url, String contentType, String content, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        HttpOp.execHttpPost(url, contentType, content, null, nullHandler, httpClient, httpContext, authenticator);
    }

    public static TypedInputStream execHttpPostStream(String url, String contentType, String content, String acceptType, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        CaptureInput handler = new CaptureInput();
        try {
            HttpOp.execHttpPost(url, contentType, content, acceptType, handler, httpClient, httpContext, authenticator);
        }
        catch (HttpException ex) {
            if (ex.getResponseCode() == 404) {
                return null;
            }
            throw ex;
        }
        return handler.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPost(String url, String contentType, String content, String acceptType, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        StringEntity e2 = null;
        try {
            e2 = new StringEntity(content, StandardCharsets.UTF_8);
            e2.setContentType(contentType);
            HttpOp.execHttpPost(url, (HttpEntity)e2, acceptType, handler, httpClient, httpContext, authenticator);
        }
        catch (Throwable throwable) {
            HttpOp.closeEntity(e2);
            throw throwable;
        }
        HttpOp.closeEntity((HttpEntity)e2);
    }

    public static void execHttpPost(String url, String contentType, InputStream input, long length) {
        HttpOp.execHttpPost(url, contentType, input, length, null, nullHandler, null, null, defaultAuthenticator);
    }

    public static void execHttpPost(String url, String contentType, InputStream input, long length, String acceptType, HttpResponseHandler handler) {
        HttpOp.execHttpPost(url, contentType, input, length, acceptType, handler, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPost(String url, String contentType, InputStream input, long length, String acceptType, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        InputStreamEntity e2 = new InputStreamEntity(input, length);
        e2.setContentType(contentType);
        e2.setContentEncoding("UTF-8");
        try {
            HttpOp.execHttpPost(url, (HttpEntity)e2, acceptType, handler, httpClient, httpContext, authenticator);
        }
        finally {
            HttpOp.closeEntity((HttpEntity)e2);
        }
    }

    public static void execHttpPost(String url, HttpEntity entity) {
        HttpOp.execHttpPost(url, entity, null, nullHandler);
    }

    public static TypedInputStream execHttpPostStream(String url, HttpEntity entity, String acceptHeader) {
        CaptureInput handler = new CaptureInput();
        HttpOp.execHttpPost(url, entity, acceptHeader, handler);
        return handler.get();
    }

    public static void execHttpPost(String url, HttpEntity entity, String acceptString, HttpResponseHandler handler) {
        HttpOp.execHttpPost(url, entity, acceptString, handler, null, null, null);
    }

    public static void execHttpPost(String url, HttpEntity entity, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        HttpOp.execHttpPost(url, entity, null, nullHandler, httpClient, httpContext, authenticator);
    }

    public static TypedInputStream execHttpPostStream(String url, HttpEntity entity, String acceptHeader, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        CaptureInput handler = new CaptureInput();
        HttpOp.execHttpPost(url, entity, acceptHeader, handler, httpClient, httpContext, authenticator);
        return handler.get();
    }

    public static void execHttpPost(String url, HttpEntity entity, String acceptHeader, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        String requestURI = HttpOp.determineRequestURI(url);
        HttpPost httppost = new HttpPost(requestURI);
        if (entity != null) {
            httppost.setEntity(entity);
        }
        HttpOp.exec(url, (HttpUriRequest)httppost, acceptHeader, handler, httpClient, httpContext, authenticator);
    }

    public static void execHttpPostForm(String url, Params params) {
        HttpOp.execHttpPostForm(url, params, null, nullHandler);
    }

    public static TypedInputStream execHttpPostFormStream(String url, Params params, String acceptHeader) {
        return HttpOp.execHttpPostFormStream(url, params, acceptHeader, null, null, null);
    }

    public static TypedInputStream execHttpPostFormStream(String url, Params params, String acceptHeader, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        CaptureInput handler = new CaptureInput();
        try {
            HttpOp.execHttpPostForm(url, params, acceptHeader, handler, httpClient, httpContext, authenticator);
        }
        catch (HttpException ex) {
            if (ex.getResponseCode() == 404) {
                return null;
            }
            throw ex;
        }
        return handler.get();
    }

    public static void execHttpPostForm(String url, Params params, String acceptString, HttpResponseHandler handler) {
        HttpOp.execHttpPostForm(url, params, acceptString, handler, null, null, null);
    }

    public static void execHttpPostForm(String url, Params params, String acceptHeader, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        if (handler == null) {
            throw new IllegalArgumentException("A HttpResponseHandler must be provided (e.g. HttpResponseLib.nullhandler)");
        }
        String requestURI = url;
        HttpPost httppost = new HttpPost(requestURI);
        httppost.setEntity(HttpOp.convertFormParams(params));
        HttpOp.exec(url, (HttpUriRequest)httppost, acceptHeader, handler, httpClient, httpContext, authenticator);
    }

    public static void execHttpPut(String url, String contentType, String content) {
        HttpOp.execHttpPut(url, contentType, content, null, null, defaultAuthenticator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPut(String url, String contentType, String content, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        StringEntity e2 = null;
        try {
            e2 = new StringEntity(content, StandardCharsets.UTF_8);
            e2.setContentType(contentType);
            HttpOp.execHttpPut(url, (HttpEntity)e2, httpClient, httpContext, authenticator);
        }
        catch (Throwable throwable) {
            HttpOp.closeEntity(e2);
            throw throwable;
        }
        HttpOp.closeEntity((HttpEntity)e2);
    }

    public static void execHttpPut(String url, String contentType, InputStream input, long length) {
        HttpOp.execHttpPut(url, contentType, input, length, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPut(String url, String contentType, InputStream input, long length, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        InputStreamEntity e2 = new InputStreamEntity(input, length);
        e2.setContentType(contentType);
        e2.setContentEncoding("UTF-8");
        try {
            HttpOp.execHttpPut(url, (HttpEntity)e2, httpClient, httpContext, authenticator);
        }
        finally {
            HttpOp.closeEntity((HttpEntity)e2);
        }
    }

    public static void execHttpPut(String url, HttpEntity entity) {
        HttpOp.execHttpPut(url, entity, null, null, null);
    }

    public static void execHttpPut(String url, HttpEntity entity, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        String requestURI = HttpOp.determineRequestURI(url);
        HttpPut httpput = new HttpPut(requestURI);
        httpput.setEntity(entity);
        HttpOp.exec(url, (HttpUriRequest)httpput, null, nullHandler, httpClient, httpContext, authenticator);
    }

    public static void execHttpHead(String url) {
        HttpOp.execHttpHead(url, null, nullHandler);
    }

    public static void execHttpHead(String url, String acceptString, HttpResponseHandler handler) {
        HttpOp.execHttpHead(url, acceptString, handler, null, null, null);
    }

    public static void execHttpHead(String url, String acceptString, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        String requestURI = HttpOp.determineRequestURI(url);
        HttpHead httpHead = new HttpHead(requestURI);
        HttpOp.exec(url, (HttpUriRequest)httpHead, acceptString, handler, httpClient, httpContext, authenticator);
    }

    public static void execHttpDelete(String url) {
        HttpOp.execHttpDelete(url, nullHandler);
    }

    public static void execHttpDelete(String url, HttpResponseHandler handler) {
        HttpOp.execHttpDelete(url, handler, null, null, null);
    }

    public static void execHttpDelete(String url, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        HttpDelete httpDelete = new HttpDelete(url);
        HttpOp.exec(url, (HttpUriRequest)httpDelete, null, handler, null, httpContext, authenticator);
    }

    private static void exec(String url, HttpUriRequest request, String acceptHeader, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext, HttpAuthenticator authenticator) {
        try {
            if (handler == null) {
                handler = nullHandler;
            }
            long id = counter.incrementAndGet();
            String requestURI = HttpOp.determineRequestURI(url);
            String baseURI = HttpOp.determineBaseIRI(url);
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, request.getMethod(), request.getURI().toString()));
            }
            if (acceptHeader != null) {
                request.addHeader("Accept", acceptHeader);
            }
            HttpOp.applyUserAgent((HttpMessage)request);
            httpClient = HttpOp.ensureClient(httpClient, authenticator);
            httpContext = HttpOp.ensureContext(httpContext);
            HttpOp.applyAuthentication(HttpOp.asAbstractClient(httpClient), url, httpContext, authenticator);
            HttpResponse response = httpClient.execute(request, httpContext);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (HttpSC.isClientError(statusCode) || HttpSC.isServerError(statusCode)) {
                log.debug(String.format("[%d] %s %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                String contentPayload = HttpOp.readPayload(response.getEntity());
                throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), contentPayload);
            }
            if (handler != null) {
                handler.handle(baseURI, response);
            }
        }
        catch (IOException ex) {
            throw new HttpException(ex);
        }
    }

    public static String readPayload(HttpEntity entity) throws IOException {
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity, (Charset)ContentType.getOrDefault((HttpEntity)entity).getCharset());
    }

    private static HttpClient ensureClient(HttpClient client, HttpAuthenticator auth) {
        if (client != null) {
            return client;
        }
        if (defaultHttpClient != null && (auth == null || useDefaultClientWithAuthentication)) {
            return defaultHttpClient;
        }
        return new SystemDefaultHttpClient();
    }

    private static AbstractHttpClient asAbstractClient(HttpClient client) {
        if (AbstractHttpClient.class.isAssignableFrom(client.getClass())) {
            return (AbstractHttpClient)client;
        }
        return null;
    }

    private static HttpContext ensureContext(HttpContext context) {
        return context != null ? context : new BasicHttpContext();
    }

    public static void applyUserAgent(HttpMessage message) {
        if (userAgent != null) {
            message.setHeader("User-Agent", userAgent);
        }
    }

    public static void applyAuthentication(AbstractHttpClient client, String target, HttpContext context, HttpAuthenticator authenticator) {
        if (client == null) {
            return;
        }
        if (authenticator == null) {
            authenticator = defaultAuthenticator;
        }
        if (authenticator == null) {
            return;
        }
        try {
            URI uri = new URI(target);
            authenticator.apply(client, context, uri);
        }
        catch (URISyntaxException e2) {
            throw new RiotException("Invalid request URI", e2);
        }
        catch (NullPointerException e3) {
            throw new RiotException("Null request URI", e3);
        }
    }

    private static HttpEntity convertFormParams(Params params) {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (Params.Pair p : params.pairs()) {
            nvps.add(new BasicNameValuePair(p.getName(), p.getValue()));
        }
        UrlEncodedFormEntity e2 = new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8);
        return e2;
    }

    private static void closeEntity(HttpEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            entity.getContent().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String determineRequestURI(String uri) {
        String requestURI = uri;
        if (requestURI.contains("#")) {
            int i = requestURI.indexOf(35);
            requestURI = requestURI.substring(0, i);
        }
        return requestURI;
    }

    private static String determineBaseIRI(String uri) {
        String baseIRI = HttpOp.determineRequestURI(uri);
        if (baseIRI.contains("?")) {
            int i = baseIRI.indexOf(63);
            baseIRI = baseIRI.substring(0, i);
        }
        return baseIRI;
    }

    static {
        userAgent = ARQ_USER_AGENT = "Apache-Jena-ARQ/" + ARQ.VERSION;
        nullHandler = HttpResponseLib.nullResponse;
    }

    public static class CaptureInput
    implements HttpCaptureResponse<TypedInputStream> {
        private TypedInputStream stream;

        @Override
        public void handle(String baseIRI, HttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            String ct = entity.getContentType() == null ? null : entity.getContentType().getValue();
            this.stream = new TypedInputStream(entity.getContent(), ct);
        }

        @Override
        public TypedInputStream get() {
            return this.stream;
        }
    }

    public static class CaptureString
    implements HttpCaptureResponse<String> {
        String result;

        @Override
        public void handle(String baseIRI, HttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            try (InputStream instream = entity.getContent();){
                this.result = IO.readWholeFileAsUTF8((InputStream)instream);
            }
        }

        @Override
        public String get() {
            return this.result;
        }
    }
}

