/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.E_OneOfBase;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformExpandOneOf
extends TransformCopy {
    static int REWRITE_LIMIT = 250;

    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList exprList = opFilter.getExprs();
        ExprList exprList2 = TransformExpandOneOf.process(exprList);
        if (exprList2 == null) {
            return super.transform(opFilter, subOp);
        }
        Op opFilter2 = OpFilter.filter(exprList2, subOp);
        return opFilter2;
    }

    @Override
    public Op transform(OpLeftJoin opLeftJoin, Op opLeft, Op opRight) {
        ExprList exprList = opLeftJoin.getExprs();
        if (exprList == null) {
            return opLeftJoin;
        }
        ExprList exprList2 = TransformExpandOneOf.process(exprList);
        if (exprList2 == null) {
            return opLeftJoin;
        }
        return OpLeftJoin.create(opLeft, opRight, exprList2);
    }

    private static ExprList process(ExprList exprList) {
        if (!TransformExpandOneOf.interesting(exprList)) {
            return null;
        }
        return TransformExpandOneOf.expand(exprList);
    }

    private static boolean interesting(ExprList exprList) {
        return exprList.getList().stream().anyMatch(e2 -> TransformExpandOneOf.processable(e2));
    }

    private static boolean processable(Expr e2) {
        return e2 instanceof E_OneOfBase && ((E_OneOfBase)e2).getRHS().size() < REWRITE_LIMIT;
    }

    private static ExprList expand(ExprList exprList) {
        ExprList exprList2 = new ExprList();
        for (Expr e2 : exprList) {
            Expr x;
            if (!TransformExpandOneOf.processable(e2)) {
                exprList2.add(e2);
                continue;
            }
            if (e2 instanceof E_OneOf) {
                E_OneOf exprOneOf = (E_OneOf)e2;
                if (exprOneOf.getRHS().size() > REWRITE_LIMIT) continue;
                x = exprOneOf.getLHS();
                ExprFunction2 disjunction = null;
                for (Expr sub : exprOneOf.getRHS()) {
                    E_Equals e22 = new E_Equals(x, sub);
                    if (disjunction == null) {
                        disjunction = e22;
                        continue;
                    }
                    disjunction = new E_LogicalOr(disjunction, e22);
                }
                if (disjunction == null) {
                    exprList2.add(NodeValue.FALSE);
                    continue;
                }
                exprList2.add(disjunction);
                continue;
            }
            if (e2 instanceof E_NotOneOf) {
                E_NotOneOf exprNotOneOf = (E_NotOneOf)e2;
                if (exprNotOneOf.getRHS().size() > REWRITE_LIMIT) continue;
                x = exprNotOneOf.getLHS();
                if (exprNotOneOf.getRHS().size() == 0) {
                    exprList2.add(NodeValue.TRUE);
                    continue;
                }
                for (Expr sub : exprNotOneOf.getRHS()) {
                    exprList2.add(new E_NotEquals(x, sub));
                }
                continue;
            }
            throw new ARQInternalErrorException();
        }
        return exprList2;
    }
}

