/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import java.io.StringReader;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.lang.SPARQLParser;
import org.apache.jena.sparql.lang.sparql_11.ParseException;
import org.apache.jena.sparql.lang.sparql_11.SPARQLParser11;
import org.apache.jena.sparql.lang.sparql_11.TokenMgrError;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.Template;

public class ParserSPARQL11
extends SPARQLParser {
    @Override
    protected Query parse$(Query query, String queryString) {
        query.setSyntax(Syntax.syntaxSPARQL_11);
        Action action = new Action(){

            @Override
            public void exec(SPARQLParser11 parser) throws Exception {
                parser.QueryUnit();
            }
        };
        ParserSPARQL11.perform(query, queryString, action);
        this.validateParsedQuery(query);
        return query;
    }

    public static Element parseElement(String string) {
        final Query query = new Query();
        Action action = new Action(){

            @Override
            public void exec(SPARQLParser11 parser) throws Exception {
                Element el = parser.GroupGraphPattern();
                query.setQueryPattern(el);
            }
        };
        ParserSPARQL11.perform(query, string, action);
        return query.getQueryPattern();
    }

    public static Template parseTemplate(String string) {
        final Query query = new Query();
        Action action = new Action(){

            @Override
            public void exec(SPARQLParser11 parser) throws Exception {
                Template t = parser.ConstructTemplate();
                query.setConstructTemplate(t);
            }
        };
        ParserSPARQL11.perform(query, string, action);
        return query.getConstructTemplate();
    }

    private static void perform(Query query, String string, Action action) {
        StringReader in = new StringReader(string);
        SPARQLParser11 parser = new SPARQLParser11(in);
        try {
            query.setStrict(true);
            parser.setQuery(query);
            action.exec(parser);
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            System.err.println(err.getMessage());
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            Log.warn(ParserSPARQL11.class, (String)"Unexpected throwable: ", (Throwable)th);
            throw new QueryException(th.getMessage(), th);
        }
    }

    private static interface Action {
        public void exec(SPARQLParser11 var1) throws Exception;
    }
}

