/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.update;

import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingUtils;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.modify.UpdateProcessRemote;
import org.apache.jena.sparql.modify.UpdateProcessRemoteForm;
import org.apache.jena.sparql.modify.UpdateProcessorBase;
import org.apache.jena.sparql.modify.UpdateProcessorStreamingBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateProcessorStreaming;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecutionFactory {
    public static UpdateProcessor create(Update update, Dataset dataset) {
        return UpdateExecutionFactory.create(new UpdateRequest(update), dataset);
    }

    public static UpdateProcessor create(Update update, DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.create(new UpdateRequest(update), datasetGraph);
    }

    public static UpdateProcessor create(Update update, Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.create(update, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessor create(Update update, DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.create(new UpdateRequest(update), datasetGraph, inputBinding);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, Dataset dataset) {
        return UpdateExecutionFactory.make(updateRequest, dataset.asDatasetGraph(), null, null);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, null, null);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.create(updateRequest, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, inputBinding, null);
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset) {
        return UpdateExecutionFactory.makeStreaming(dataset.asDatasetGraph(), null, null);
    }

    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, null, null);
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.createStreaming(dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, inputBinding, null);
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset, Context context) {
        return UpdateExecutionFactory.makeStreaming(dataset.asDatasetGraph(), null, context);
    }

    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Context context) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, null, context);
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset, QuerySolution inputBinding, Context context) {
        return UpdateExecutionFactory.createStreaming(dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding), context);
    }

    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Binding inputBinding, Context context) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, inputBinding, context);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, Dataset dataset, Context context) {
        return UpdateExecutionFactory.make(updateRequest, dataset.asDatasetGraph(), null, context);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Context context) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, null, context);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, Dataset dataset, QuerySolution inputBinding, Context context) {
        return UpdateExecutionFactory.create(updateRequest, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding), context);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding, Context context) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, inputBinding, context);
    }

    private static UpdateProcessor make(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding, Context context) {
        UpdateEngineFactory f;
        if (context == null) {
            context = ARQ.getContext().copy();
            context.putAll(datasetGraph.getContext());
        }
        if ((f = UpdateEngineRegistry.get().find(datasetGraph, context)) == null) {
            return null;
        }
        UpdateProcessorBase uProc = new UpdateProcessorBase(updateRequest, datasetGraph, inputBinding, context, f);
        return uProc;
    }

    private static UpdateProcessorStreaming makeStreaming(DatasetGraph datasetGraph, Binding inputBinding, Context context) {
        UpdateEngineFactory f;
        if (context == null) {
            context = ARQ.getContext().copy();
            context.putAll(datasetGraph.getContext());
        }
        if ((f = UpdateEngineRegistry.get().find(datasetGraph, context)) == null) {
            return null;
        }
        UpdateProcessorStreamingBase uProc = new UpdateProcessorStreamingBase(datasetGraph, inputBinding, context, f);
        return uProc;
    }

    public static UpdateProcessor createRemote(Update update, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update), remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemote(Update update, String remoteEndpoint, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update), remoteEndpoint, null, authenticator);
    }

    public static UpdateProcessor createRemote(Update update, String remoteEndpoint, Context context) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update), remoteEndpoint, context, null);
    }

    public static UpdateProcessor createRemote(Update update, String remoteEndpoint, Context context, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update), remoteEndpoint, context, authenticator);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, null, authenticator);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, context, null);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context, HttpAuthenticator authenticator) {
        return new UpdateProcessRemote(updateRequest, remoteEndpoint, context, authenticator);
    }

    public static UpdateProcessor createRemoteForm(Update update, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemoteForm(update, remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemoteForm(Update update, String remoteEndpoint, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemoteForm(update, remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemoteForm(Update update, String remoteEndpoint, Context context) {
        return UpdateExecutionFactory.createRemoteForm(new UpdateRequest(update), remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemoteForm(Update update, String remoteEndpoint, Context context, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemoteForm(new UpdateRequest(update), remoteEndpoint, null, authenticator);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, null, null);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, HttpAuthenticator authenticator) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, null, authenticator);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context) {
        return new UpdateProcessRemoteForm(updateRequest, remoteEndpoint, context);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context, HttpAuthenticator authenticator) {
        return new UpdateProcessRemoteForm(updateRequest, remoteEndpoint, context, authenticator);
    }
}

