/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.springframework.binding.form.FormModel;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.form.binding.support.CustomBinding;
import org.springframework.util.Assert;

public class EnumRadioButtonBinding
extends CustomBinding {
    private JPanel contentPanel;
    private List<Enum> selectableEnumsList;
    private Map<String, ContainerJRadioButton<Enum>> radioButtons;
    private Class propertyType;
    private ButtonGroup group;
    private MessageSourceAccessor messageSourceAccessor;

    public EnumRadioButtonBinding(JPanel contentPanel, FormModel formModel, String formPropertyPath, Class<?> propertyType, List<Enum> selectableEnumsList) {
        super(formModel, formPropertyPath, propertyType);
        this.contentPanel = contentPanel;
        this.propertyType = propertyType;
        this.radioButtons = new LinkedHashMap<String, ContainerJRadioButton<Enum>>();
        this.messageSourceAccessor = this.getMessages();
        this.selectableEnumsList = selectableEnumsList;
        this.createRadioButtons();
    }

    protected void valueModelChanged(Object newValue) {
        this.deselectAll();
        Enum enumValue = (Enum)newValue;
        ContainerJRadioButton<Enum> button = enumValue == null ? this.radioButtons.get(null) : this.radioButtons.get(enumValue.name());
        if (button != null) {
            button.setSelected(true);
        }
    }

    private void deselectAll() {
        if (this.group != null) {
            this.group.clearSelection();
        }
    }

    protected JComponent doBindControl() {
        Assert.notNull(this.selectableEnumsList);
        return this.createBindingControl();
    }

    private JPanel createBindingControl() {
        this.group = new ButtonGroup();
        FormLayout layout = new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC}, EnumRadioButtonBinding.getDefaultRowsWithGap(this.radioButtons.keySet().size()));
        int count = 1;
        this.contentPanel.setLayout((LayoutManager)layout);
        for (ContainerJRadioButton<Enum> button : this.radioButtons.values()) {
            this.group.add(button);
            this.contentPanel.add(button, new CellConstraints(1, count));
            count += 2;
        }
        this.valueModelChanged(this.getValue());
        return this.contentPanel;
    }

    private static RowSpec[] getDefaultRowsWithGap(int rowCount) {
        ArrayList<RowSpec> rows = new ArrayList<RowSpec>();
        for (int i = 0; i < rowCount; ++i) {
            rows.add(new RowSpec("fill:pref:nogrow"));
            rows.add(FormFactory.LINE_GAP_ROWSPEC);
        }
        rows.remove(rows.size() - 1);
        return rows.toArray(new RowSpec[0]);
    }

    protected void enabledChanged() {
        for (ContainerJRadioButton<Enum> button : this.radioButtons.values()) {
            button.setEnabled(this.isEnabled());
        }
    }

    protected void readOnlyChanged() {
        for (ContainerJRadioButton<Enum> button : this.radioButtons.values()) {
            button.setEnabled(this.isReadOnly());
        }
    }

    private void createRadioButtons() {
        for (Enum enumValue : this.selectableEnumsList) {
            String text;
            ContainerJRadioButton<Enum> button = new ContainerJRadioButton<Enum>();
            if (enumValue == null) {
                text = this.messageSourceAccessor.getMessage(this.propertyType.getName() + ".null", "null");
                button.setText(text == null ? this.propertyType.getName() + ".null" : text);
            } else {
                text = this.messageSourceAccessor.getMessage(this.propertyType.getName() + "." + enumValue.name(), enumValue.name());
                button.setText(text == null ? this.propertyType.getName() + "." + enumValue.name() : text);
            }
            button.setContainedObject(enumValue);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContainerJRadioButton button = (ContainerJRadioButton)e.getSource();
                    EnumRadioButtonBinding.this.controlValueChanged(button.getContainedObject());
                }
            });
            if (enumValue == null) {
                this.radioButtons.put(null, button);
                continue;
            }
            this.radioButtons.put(enumValue.name(), button);
        }
    }

    private class ContainerJRadioButton<T>
    extends JRadioButton {
        private T containedObject;

        private ContainerJRadioButton() {
        }

        public T getContainedObject() {
            return this.containedObject;
        }

        public void setContainedObject(T containedObject) {
            this.containedObject = containedObject;
        }
    }
}

