/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.support;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.FatalBeanException;
import org.springframework.binding.value.PropertyChangePublisher;
import org.springframework.util.Assert;

public abstract class PropertyChangeSupportUtils {
    private static final Class[] NAMED_PCL_PARAMS = new Class[]{String.class, PropertyChangeListener.class};

    public static boolean supportsBoundProperties(Class beanClass) {
        return PropertyChangePublisher.class.isAssignableFrom(beanClass) || PropertyChangeSupportUtils.getNamedPCLAdder(beanClass) != null && PropertyChangeSupportUtils.getNamedPCLRemover(beanClass) != null;
    }

    public static void addPropertyChangeListener(Object bean, String propertyName, PropertyChangeListener listener) {
        Assert.notNull((Object)propertyName, (String)"The property name must not be null.");
        Assert.notNull((Object)listener, (String)"The listener must not be null.");
        if (bean instanceof PropertyChangePublisher) {
            ((PropertyChangePublisher)bean).addPropertyChangeListener(propertyName, listener);
        } else {
            Class<?> beanClass = bean.getClass();
            Method namedPCLAdder = PropertyChangeSupportUtils.getNamedPCLAdder(beanClass);
            if (namedPCLAdder == null) {
                throw new FatalBeanException("Could not find the bean method/npublic void addPropertyChangeListener(String, PropertyChangeListener);/nin bean '" + bean + "'");
            }
            try {
                namedPCLAdder.invoke(bean, propertyName, listener);
            }
            catch (InvocationTargetException e) {
                throw new FatalBeanException("Due to an InvocationTargetException we failed to add a named PropertyChangeListener to bean '" + bean + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FatalBeanException("Due to an IllegalAccessException we failed to add a named PropertyChangeListener to bean '" + bean + "'", (Throwable)e);
            }
        }
    }

    public static void removePropertyChangeListener(Object bean, String propertyName, PropertyChangeListener listener) {
        Assert.notNull((Object)propertyName, (String)"The property name must not be null.");
        Assert.notNull((Object)listener, (String)"The listener must not be null.");
        if (bean instanceof PropertyChangePublisher) {
            ((PropertyChangePublisher)bean).removePropertyChangeListener(propertyName, listener);
        } else {
            Class<?> beanClass = bean.getClass();
            Method namedPCLRemover = PropertyChangeSupportUtils.getNamedPCLRemover(beanClass);
            if (namedPCLRemover == null) {
                throw new FatalBeanException("Could not find the bean method/npublic void removePropertyChangeListener(String, PropertyChangeListener);/nin bean '" + bean + "'");
            }
            try {
                namedPCLRemover.invoke(bean, propertyName, listener);
            }
            catch (InvocationTargetException e) {
                throw new FatalBeanException("Due to an InvocationTargetException we failed to remove a named PropertyChangeListener from bean '" + bean + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FatalBeanException("Due to an IllegalAccessException we failed to remove a named PropertyChangeListener from bean '" + bean + "'", (Throwable)e);
            }
        }
    }

    private static Method getNamedPCLAdder(Class beanClass) {
        try {
            return beanClass.getMethod("addPropertyChangeListener", NAMED_PCL_PARAMS);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getNamedPCLRemover(Class beanClass) {
        try {
            return beanClass.getMethod("removePropertyChangeListener", NAMED_PCL_PARAMS);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

