/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.value.PropertyChangePublisher;
import org.springframework.util.ObjectUtils;

public abstract class AbstractPropertyChangePublisher
implements PropertyChangePublisher {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private transient PropertyChangeSupport changeSupport;
    private transient VetoableChangeSupport vetoSupport;

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public final void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.vetoSupport == null) {
            this.vetoSupport = new VetoableChangeSupport(this);
        }
        this.vetoSupport.addVetoableChangeListener(listener);
    }

    public final void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null || this.vetoSupport == null) {
            return;
        }
        this.vetoSupport.removeVetoableChangeListener(listener);
    }

    public final void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.vetoSupport == null) {
            this.vetoSupport = new VetoableChangeSupport(this);
        }
        this.vetoSupport.addVetoableChangeListener(propertyName, listener);
    }

    public final void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (listener == null || this.vetoSupport == null) {
            return;
        }
        this.vetoSupport.removeVetoableChangeListener(propertyName, listener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    public final VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoSupport == null) {
            return new VetoableChangeListener[0];
        }
        return this.vetoSupport.getVetoableChangeListeners();
    }

    public final VetoableChangeListener[] getVetoableChangeListeners(String propertyName) {
        if (this.vetoSupport == null) {
            return new VetoableChangeListener[0];
        }
        return this.vetoSupport.getVetoableChangeListeners(propertyName);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport aChangeSupport = this.changeSupport;
        if (aChangeSupport == null) {
            return;
        }
        aChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeSupport aChangeSupport = this.changeSupport;
        if (aChangeSupport == null) {
            return;
        }
        aChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    protected final void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        PropertyChangeSupport aChangeSupport = this.changeSupport;
        if (aChangeSupport == null) {
            return;
        }
        aChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
    }

    protected final void firePropertiesChanged() {
        this.firePropertyChange(null, null, null);
    }

    protected final void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        VetoableChangeSupport aVetoSupport = this.vetoSupport;
        if (aVetoSupport == null) {
            return;
        }
        aVetoSupport.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected final void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        VetoableChangeSupport aVetoSupport = this.vetoSupport;
        if (aVetoSupport == null) {
            return;
        }
        aVetoSupport.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected final void fireVetoableChange(String propertyName, double oldValue, double newValue) throws PropertyVetoException {
        this.fireVetoableChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    protected final void fireVetoableChange(String propertyName, int oldValue, int newValue) throws PropertyVetoException {
        VetoableChangeSupport aVetoSupport = this.vetoSupport;
        if (aVetoSupport == null) {
            return;
        }
        aVetoSupport.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected final void fireVetoableChange(String propertyName, float oldValue, float newValue) throws PropertyVetoException {
        this.fireVetoableChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    protected final void fireVetoableChange(String propertyName, long oldValue, long newValue) throws PropertyVetoException {
        this.fireVetoableChange(propertyName, new Long(oldValue), new Long(newValue));
    }

    protected boolean hasChanged(Object currentValue, Object proposedValue) {
        return !ObjectUtils.nullSafeEquals((Object)currentValue, (Object)proposedValue);
    }

    protected final boolean hasChanged(boolean currentValue, boolean proposedValue) {
        return currentValue != proposedValue;
    }

    protected final boolean hasChanged(int currentValue, int proposedValue) {
        return currentValue != proposedValue;
    }

    protected final boolean hasChanged(long currentValue, long proposedValue) {
        return currentValue != proposedValue;
    }

    protected final boolean hasChanged(float currentValue, float proposedValue) {
        return currentValue != proposedValue;
    }

    protected final boolean hasChanged(double currentValue, double proposedValue) {
        return currentValue != proposedValue;
    }
}

