/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.value.ValueModel;

public abstract class AbstractValueModelAdapter {
    protected static final Log logger = LogFactory.getLog((Class)AbstractValueModelAdapter.class);
    private final ValueModelChangeHandler valueModelChangeHandler = new ValueModelChangeHandler();
    private ValueModel valueModel;

    public AbstractValueModelAdapter(ValueModel valueModel) {
        this.valueModel = valueModel;
        this.valueModel.addValueChangeListener(this.valueModelChangeHandler);
    }

    protected void initalizeAdaptedValue() {
        this.valueModelValueChanged(this.valueModel.getValue());
    }

    protected ValueModel getValueModel() {
        return this.valueModel;
    }

    protected void adaptedValueChanged(Object newValue) {
        if (this.valueModel != null) {
            this.valueModel.setValueSilently(newValue, this.valueModelChangeHandler);
        }
    }

    protected abstract void valueModelValueChanged(Object var1);

    private class ValueModelChangeHandler
    implements PropertyChangeListener {
        private ValueModelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractValueModelAdapter.this.valueModelValueChanged(AbstractValueModelAdapter.this.valueModel.getValue());
        }
    }
}

