/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.springframework.binding.value.CommitTrigger;
import org.springframework.binding.value.CommitTriggerListener;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractValueModel;
import org.springframework.binding.value.support.ValueModelWrapper;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class BufferedValueModel
extends AbstractValueModel
implements ValueModelWrapper {
    public static final String BUFFERING_PROPERTY = "buffering";
    private final ValueModel wrappedModel;
    private final PropertyChangeListener wrappedModelChangeHandler;
    private Object bufferedValue;
    private CommitTrigger commitTrigger;
    private CommitTriggerListener commitTriggerHandler;
    private boolean buffering;

    public BufferedValueModel(ValueModel wrappedModel) {
        this(wrappedModel, null);
    }

    public BufferedValueModel(ValueModel wrappedModel, CommitTrigger commitTrigger) {
        Assert.notNull((Object)wrappedModel, (String)"Wrapped value model can not be null.");
        this.wrappedModel = wrappedModel;
        this.wrappedModelChangeHandler = new WrappedModelValueChangeHandler();
        this.wrappedModel.addValueChangeListener(this.wrappedModelChangeHandler);
        this.bufferedValue = wrappedModel.getValue();
        this.setCommitTrigger(commitTrigger);
    }

    public final CommitTrigger getCommitTrigger() {
        return this.commitTrigger;
    }

    public final void setCommitTrigger(CommitTrigger commitTrigger) {
        if (this.commitTrigger == commitTrigger) {
            return;
        }
        if (this.commitTrigger != null) {
            this.commitTrigger.removeCommitTriggerListener(this.commitTriggerHandler);
            this.commitTrigger = null;
        }
        if (commitTrigger != null) {
            if (this.commitTriggerHandler == null) {
                this.commitTriggerHandler = new CommitTriggerHandler();
            }
            this.commitTrigger = commitTrigger;
            this.commitTrigger.addCommitTriggerListener(this.commitTriggerHandler);
        }
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    public Object getValue() {
        return this.bufferedValue;
    }

    public void setValue(Object value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting buffered value to '" + value + "'"));
        }
        Object oldValue = this.getValue();
        this.bufferedValue = value;
        this.updateBuffering();
        this.fireValueChange(oldValue, this.bufferedValue);
    }

    public final ValueModel getWrappedValueModel() {
        return this.wrappedModel;
    }

    public final ValueModel getInnerMostWrappedValueModel() {
        if (this.wrappedModel instanceof ValueModelWrapper) {
            return ((ValueModelWrapper)((Object)this.wrappedModel)).getInnerMostWrappedValueModel();
        }
        return this.wrappedModel;
    }

    protected void onWrappedValueChanged() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Wrapped model value has changed; new value is '" + this.wrappedModel.getValue() + "'"));
        }
        this.setValue(this.wrappedModel.getValue());
    }

    public void commit() {
        if (this.isBuffering()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Committing buffered value '" + this.getValue() + "' to wrapped value model '" + this.wrappedModel + "'"));
            }
            this.wrappedModel.setValueSilently(this.getValueToCommit(), this.wrappedModelChangeHandler);
            this.setValue(this.wrappedModel.getValue());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No buffered edit to commit; nothing to do...");
        }
    }

    protected Object getValueToCommit() {
        return this.bufferedValue;
    }

    private void updateBuffering() {
        boolean wasBuffering = this.isBuffering();
        this.buffering = this.hasValueChanged(this.wrappedModel.getValue(), this.bufferedValue);
        this.firePropertyChange(BUFFERING_PROPERTY, wasBuffering, this.buffering);
    }

    public final void revert() {
        if (this.isBuffering()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Reverting buffered value '" + this.getValue() + "' to value '" + this.wrappedModel.getValue() + "'"));
            }
            this.setValue(this.wrappedModel.getValue());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No buffered edit to commit; nothing to do...");
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("bufferedValue", this.bufferedValue).toString();
    }

    private class CommitTriggerHandler
    implements CommitTriggerListener {
        private CommitTriggerHandler() {
        }

        public void commit() {
            if (BufferedValueModel.this.logger.isDebugEnabled()) {
                BufferedValueModel.this.logger.debug((Object)"Commit trigger fired commit event.");
            }
            BufferedValueModel.this.commit();
        }

        public void revert() {
            if (BufferedValueModel.this.logger.isDebugEnabled()) {
                BufferedValueModel.this.logger.debug((Object)"Commit trigger fired revert event.");
            }
            BufferedValueModel.this.revert();
        }
    }

    private class WrappedModelValueChangeHandler
    implements PropertyChangeListener {
        private WrappedModelValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BufferedValueModel.this.onWrappedValueChanged();
        }
    }
}

